//***** Geant4.9.4: Generated by Geant4 Geometry Editor at  Tue Nov 30 10:52:20 JST 2010 *****

//------HeaderFile-
 #include "Various_Solids_Copied.hh"

#include "G4UnitsTable.hh"

#include "G4VUserDetectorConstruction.hh"

#include "globals.hh"
#include "G4Material.hh"
#include "G4MaterialTable.hh"
#include "G4Element.hh"
#include "G4ElementTable.hh"
#include "G4Box.hh"
#include "G4Tubs.hh"
#include "G4Cons.hh"
#include "G4Sphere.hh"
#include "G4BREPSolidPolyhedra.hh"
#include "G4LogicalVolume.hh"
#include "G4ThreeVector.hh"
#include "G4PVPlacement.hh"
#include "G4PVReplica.hh"
#include "G4SDManager.hh"
#include "G4VisAttributes.hh"
#include "G4Colour.hh"

Various_Solids_Copied::Various_Solids_Copied()
{ ; }
Various_Solids_Copied::~Various_Solids_Copied()
{ ; }
G4VPhysicalVolume* Various_Solids_Copied::Construct( )
{
// Elements
G4Element* elementN = new G4Element( "Nitrogen", "N", 7. , 14.00674*g/mole );
G4Element* elementO = new G4Element( "Oxygen", "O", 8. , 15.9994*g/mole );
G4Element* elementH = new G4Element( "Hydrogen", "H", 1. , 1.00794*g/mole );
G4Element* elementC = new G4Element( "Carbon", "C", 6. , 12.011*g/mole );
G4Element* elementGe = new G4Element( "Germanium", "Ge", 32. , 72.61*g/mole );
G4Element* elementBi = new G4Element( "Bismuth", "Bi", 83. , 208.98037*g/mole );
G4Element* elementF = new G4Element( "Fluorine", "F", 9. , 18.9984032*g/mole );
G4Element* elementNa = new G4Element( "Sodium", "Na", 11. , 22.989768*g/mole );

// Materials from Combination

G4Material* Air = new G4Material("Air",  1.205*mg/cm3, 2, kStateUndefined, 293.15*kelvin, 1.0*atmosphere );
Air->AddElement( elementN, 1 );
Air->AddElement( elementO, 0 );
G4Material* Paraffin = new G4Material("Paraffin",  0.93*g/cm3, 2, kStateUndefined, 273.15*kelvin, 1.0*atmosphere );
Paraffin->AddElement( elementH, 52 );
Paraffin->AddElement( elementC, 25 );
G4Material* Plexiglas = new G4Material("Plexiglas",  1.18*g/cm3, 3, kStateUndefined, 273.15*kelvin, 1.0*atmosphere );
Plexiglas->AddElement( elementH, 8 );
Plexiglas->AddElement( elementC, 5 );
Plexiglas->AddElement( elementO, 2 );
G4Material* BGO = new G4Material("BGO",  7.1*g/cm3, 3, kStateUndefined, 273.15*kelvin, 1.0*atmosphere );
BGO->AddElement( elementO, 12 );
BGO->AddElement( elementGe, 3 );
BGO->AddElement( elementBi, 4 );
G4Material* NaF = new G4Material("NaF",  2.558*g/cm3, 2, kStateUndefined, 273.15*kelvin, 1.0*atmosphere );
NaF->AddElement( elementF, 1 );
NaF->AddElement( elementNa, 1 );

// Materials from Scratch

G4Material* Aluminum = new G4Material("Aluminum", 13, 26.981539*g/mole, 2.7*g/cm3,kStateSolid, 273.15*kelvin, 1.0*atmosphere );
G4Material* Copper = new G4Material("Copper", 29, 63.546*g/mole, 8.96*g/cm3,kStateSolid, 273.15*kelvin, 1.0*atmosphere );
G4Material* Uranium = new G4Material("Uranium", 92, 238.0289*g/mole, 18.95*g/cm3,kStateSolid, 273.15*kelvin, 1.0*atmosphere );

// Visualization attributes


G4VisAttributes * lightblue= new G4VisAttributes( G4Colour(204/255. ,255/255. ,255/255. ));
lightblue -> SetVisibility(true);
G4VisAttributes * indigo= new G4VisAttributes( G4Colour(0/255. ,204/255. ,204/255. ));
indigo -> SetVisibility(true);
G4VisAttributes * cyan= new G4VisAttributes( G4Colour(0/255. ,0/255. ,255/255. ));
cyan -> SetVisibility(true);
G4VisAttributes * orange= new G4VisAttributes( G4Colour(255/255. ,153/255. ,153/255. ));
orange -> SetVisibility(true);
G4VisAttributes * green= new G4VisAttributes( G4Colour(51/255. ,255/255. ,51/255. ));
green -> SetVisibility(true);
G4VisAttributes * violet= new G4VisAttributes( G4Colour(153/255. ,0/255. ,153/255. ));
violet -> SetVisibility(true);
G4VisAttributes * brown= new G4VisAttributes( G4Colour(153/255. ,102/255. ,0/255. ));
brown -> SetVisibility(true);
G4VisAttributes * scarlet= new G4VisAttributes( G4Colour(204/255. ,0/255. ,0/255. ));
scarlet -> SetVisibility(true);
// Logical  Volumes

G4Box *solidbox= new G4Box("solidbox", 1000.0*mm, 1000.0*mm, 1000.0*mm );
G4LogicalVolume * box = new G4LogicalVolume(solidbox, 	 //its solid
			 Air, 		 //its material
			"box" ,		 //its name
			 0,0,0);

box->SetVisAttributes(lightblue);

G4Tubs *solidtube= new G4Tubs("solidtube", 16.0*mm, 20.0*mm, 15.0*mm, 30.0*deg, 210.0*deg );
G4LogicalVolume * tube = new G4LogicalVolume(solidtube, 	 //its solid
			 BGO, 		 //its material
			"tube" ,		 //its name
			 0,0,0);

tube->SetVisAttributes(indigo);

G4Cons *solidcone= new G4Cons("solidcone", 5.0*mm, 20.0*mm, 10.0*mm, 25.0*mm, 18.0*mm, 15.0*deg, 330.0*deg );
G4LogicalVolume * cone = new G4LogicalVolume(solidcone, 	 //its solid
			 Copper, 		 //its material
			"cone" ,		 //its name
			 0,0,0);

cone->SetVisAttributes(cyan);

G4Sphere *solidsphere= new G4Sphere("solidsphere", 19.0*mm, 28.0*mm, 10.0*deg, 90.0*deg, 30.0*deg, 90.0*deg );
G4LogicalVolume * sphere = new G4LogicalVolume(solidsphere, 	 //its solid
			 Plexiglas, 		 //its material
			"sphere" ,		 //its name
			 0,0,0);

sphere->SetVisAttributes(orange);

G4double DzArraypolygone   [] = {0.0*mm, 12.0*mm, 24.0*mm, 36.0*mm, 48.0*mm};
G4double RminArraypolygone [] = {8.0*mm, 4.0*mm, 8.0*mm, 4.0*mm, 8.0*mm};
G4double RmaxArraypolygone [] = {20.0*mm, 6.0*mm, 20.0*mm, 6.0*mm, 20.0*mm};

G4BREPSolidPolyhedra *solidpolygone = new G4BREPSolidPolyhedra("solidpolygone", 	 //its name
		 0.0*deg, 		 //its start angle
		 360.0*deg,		 //its opening angle
		 5,		 //its sides
		 5, 		 //its nZ
		 DzArraypolygone[0], 		 //z start 
		 DzArraypolygone, 		 //z value 
		 RminArraypolygone, 		 //rmin 
		 RmaxArraypolygone ); 		 //rmax
G4LogicalVolume * polygone = new G4LogicalVolume(solidpolygone, 	 //its solid
			 Paraffin, 		 //its material
			"polygone" ,		 //its name
			 0,0,0);

polygone->SetVisAttributes(brown);


// Physical Volumes ----  Single Positioned Placement,   Repeated Placement,   Slicing  --------------------------- 


// Single Positioned Placement 

G4RotationMatrix rotMatrixworld;   // unit rotation matrix
G4double angleworld = 0.0*deg;   // rotational angle
rotMatrixworld.rotateX(angleworld);  // rot matrix

G4VPhysicalVolume *  world= new G4PVPlacement(G4Transform3D(rotMatrixworld,	//rotation 
		 G4ThreeVector(0.0*mm, 0.0*mm, 0.0*mm)),
		 "world",   //its name  (2nd constructor)
		 box,         //its logical volume 
		 NULL,              //its mother volume 
		 false,                 //no boolean operation 
		 0);                       //copy number 


// Repeated Placement Translation 

G4int copytubearray;
copytubearray=0;
for (G4int indextubearray=1; indextubearray<=15; indextubearray++){
  G4double transtubearray =-900.0*mm+100.0*mm*(indextubearray-1);
  G4VPhysicalVolume * tubearray = new G4PVPlacement(0,      //no rotation 
		 G4ThreeVector(transtubearray, 0.0*mm, 0.0*mm),
		 "tubearray",   //its name 
		 tube,         //its logical volume
		 world,            //its mother volume
		 false,             //no boolean operation
		 copytubearray++);      //copy number 
}

G4int copyconearray;
copyconearray=0;
for (G4int indexconearray=1; indexconearray<=10; indexconearray++){
  G4double transconearray = 0.0*mm+100.0*mm*(indexconearray-1);
  G4VPhysicalVolume * conearray = new G4PVPlacement(0,       //no rotation 
		 G4ThreeVector(0.0*mm, transconearray, 0.0*mm),
		 "conearray",    //its name 
		 cone,          //its logical volume
		 world,             //its mother volume
		 false,             //no boolean operation
		 copyconearray++);      //copy number 
}

G4int copyspherearray;
copyspherearray=0;
for (G4int indexspherearray=1; indexspherearray<=6;indexspherearray++){
  G4double transspherearray = 0.0*mm+80.0*mm*(indexspherearray-1);
  G4VPhysicalVolume * spherearray = new G4PVPlacement(0,           //no rotation 
		 G4ThreeVector(-900.0*mm, -600.0*mm, transspherearray),
		 "spherearray",        //its name 
		 sphere,              //its logical volume
		 world,                 //its mother volume
		 false,                 //no boolean operation
		 copyspherearray++);          //copy number
}

// Repeated Placement AxialSymmetoric

// Active Rotation of Bodies
G4int copyrotatepgone;
copyrotatepgone=0;
G4RotationMatrix rotationMatrixrotatepgone;G4double startrotatepgone = 170.0*deg;
G4double incrotatepgone = 15.0*deg;
rotationMatrixrotatepgone.rotateZ(startrotatepgone);
G4double x0rotatepgone = 0.0*mm;
G4double y0rotatepgone = 0.0*mm;
G4double z0rotatepgone = 200.0*mm;
G4double radiusrotatepgone = 400.0*mm;

for (G4int indexrotatepgone=1; indexrotatepgone<=20; indexrotatepgone++){
  G4double transrotatepgone = startrotatepgone+incrotatepgone*(indexrotatepgone-1);

  G4double xrotatepgone, yrotatepgone, zrotatepgone;
  xrotatepgone = x0rotatepgone + radiusrotatepgone * cos(transrotatepgone);
  yrotatepgone = y0rotatepgone + radiusrotatepgone * sin(transrotatepgone);
  zrotatepgone = z0rotatepgone;
  G4VPhysicalVolume * rotatepgone = new G4PVPlacement(G4Transform3D(rotationMatrixrotatepgone,	//rotate
		 G4ThreeVector(xrotatepgone, yrotatepgone, zrotatepgone)),
		 "rotatepgone",   //its name 
		 polygone,         //its logical volume
		 world,            //its mother volume
		 false,             //no boolean operation
		 copyrotatepgone++);      //copy number 
  rotationMatrixrotatepgone.rotateZ(incrotatepgone);
}


// Slicing Translation 


// Slicing AxialSymmetric 


// return the physical World


 return world;
}
