! Copyright (c) 2007 Aaron Schaefer.
! See http://factorcode.org/license.txt for BSD license.
USING: kernel math project-euler.common ;
IN: project-euler.012

! http://projecteuler.net/index.php?section=problems&id=12

! DESCRIPTION
! -----------

! The sequence of triangle numbers is generated by adding the natural numbers.
! So the 7th triangle number would be 1 + 2 + 3 + 4 + 5 + 6 + 7 = 28. The first
! ten terms would be:

!     1, 3, 6, 10, 15, 21, 28, 36, 45, 55, ...

! Let us list the factors of the first seven triangle numbers:

!      1: 1
!      3: 1,3
!      6: 1,2,3,6
!     10: 1,2,5,10
!     15: 1,3,5,15
!     21: 1,3,7,21
!     28: 1,2,4,7,14,28

! We can see that the 7th triangle number, 28, is the first triangle number to
! have over five divisors.

! Which is the first triangle number to have over five-hundred divisors?


! SOLUTION
! --------

: euler012 ( -- answer )
    8 [ dup nth-triangle tau* 500 < ] [ 1 + ] while nth-triangle ;

! [ euler012 ] 10 ave-time
! 6573 ms ave run time - 346.27 SD (10 trials)

SOLUTION: euler012
