/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.util.Collections;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.eclipse.aether.transport.http.ChecksumExtractor;

@Singleton
@Named(value="nexus2")
public class Nexus2ChecksumExtractor
extends ChecksumExtractor {
    public static final String NAME = "nexus2";

    @Override
    public Map<String, String> extractChecksums(HttpResponse response) {
        String etag;
        Header header = response.getFirstHeader("ETag");
        String string2 = etag = header != null ? header.getValue() : null;
        if (etag != null) {
            int start2 = etag.indexOf("SHA1{");
            int end = etag.indexOf("}", start2 + 5);
            if (start2 >= 0 && end > start2) {
                return Collections.singletonMap("SHA-1", etag.substring(start2 + 5, end));
            }
        }
        return null;
    }
}

