/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.artifact.AttachedArtifact;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=MavenProjectHelper.class)
public class DefaultMavenProjectHelper
extends AbstractLogEnabled
implements MavenProjectHelper {
    @Requirement
    private ArtifactHandlerManager artifactHandlerManager;

    @Override
    public void attachArtifact(MavenProject project2, String artifactType, String artifactClassifier, File artifactFile) {
        String type2 = artifactType;
        ArtifactHandler handler = null;
        if (type2 != null) {
            handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        }
        if (handler == null) {
            handler = this.artifactHandlerManager.getArtifactHandler("jar");
        }
        AttachedArtifact artifact = new AttachedArtifact(project2.getArtifact(), artifactType, artifactClassifier, handler);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project2, artifact);
    }

    @Override
    public void attachArtifact(MavenProject project2, String artifactType, File artifactFile) {
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(artifactType);
        AttachedArtifact artifact = new AttachedArtifact(project2.getArtifact(), artifactType, handler);
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project2, artifact);
    }

    @Override
    public void attachArtifact(MavenProject project2, File artifactFile, String artifactClassifier) {
        Artifact projectArtifact = project2.getArtifact();
        AttachedArtifact artifact = new AttachedArtifact(projectArtifact, projectArtifact.getType(), artifactClassifier, projectArtifact.getArtifactHandler());
        artifact.setFile(artifactFile);
        artifact.setResolved(true);
        this.attachArtifact(project2, artifact);
    }

    public void attachArtifact(MavenProject project2, Artifact artifact) {
        project2.addAttachedArtifact(artifact);
    }

    @Override
    public void addResource(MavenProject project2, String resourceDirectory, List<String> includes, List<String> excludes) {
        Resource resource2 = new Resource();
        resource2.setDirectory(resourceDirectory);
        resource2.setIncludes(includes);
        resource2.setExcludes(excludes);
        project2.addResource(resource2);
    }

    @Override
    public void addTestResource(MavenProject project2, String resourceDirectory, List<String> includes, List<String> excludes) {
        Resource resource2 = new Resource();
        resource2.setDirectory(resourceDirectory);
        resource2.setIncludes(includes);
        resource2.setExcludes(excludes);
        project2.addTestResource(resource2);
    }
}

