/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.message.HeaderValueFormatter;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicHeaderValueFormatter
implements HeaderValueFormatter {
    @Deprecated
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final BasicHeaderValueFormatter INSTANCE = new BasicHeaderValueFormatter();
    public static final String SEPARATORS = " ;,:@()<>\\\"/[]?={}\t";
    public static final String UNSAFE_CHARS = "\"\\";

    public static String formatElements(HeaderElement[] elems, boolean quote, HeaderValueFormatter formatter2) {
        return (formatter2 != null ? formatter2 : INSTANCE).formatElements(null, elems, quote).toString();
    }

    @Override
    public CharArrayBuffer formatElements(CharArrayBuffer charBuffer, HeaderElement[] elems, boolean quote) {
        Args.notNull(elems, "Header element array");
        int len = this.estimateElementsLen(elems);
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len);
        } else {
            buffer2.ensureCapacity(len);
        }
        for (int i = 0; i < elems.length; ++i) {
            if (i > 0) {
                buffer2.append(", ");
            }
            this.formatHeaderElement(buffer2, elems[i], quote);
        }
        return buffer2;
    }

    protected int estimateElementsLen(HeaderElement[] elems) {
        if (elems == null || elems.length < 1) {
            return 0;
        }
        int result = (elems.length - 1) * 2;
        for (HeaderElement elem : elems) {
            result += this.estimateHeaderElementLen(elem);
        }
        return result;
    }

    public static String formatHeaderElement(HeaderElement elem, boolean quote, HeaderValueFormatter formatter2) {
        return (formatter2 != null ? formatter2 : INSTANCE).formatHeaderElement(null, elem, quote).toString();
    }

    @Override
    public CharArrayBuffer formatHeaderElement(CharArrayBuffer charBuffer, HeaderElement elem, boolean quote) {
        int parcnt;
        Args.notNull(elem, "Header element");
        int len = this.estimateHeaderElementLen(elem);
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len);
        } else {
            buffer2.ensureCapacity(len);
        }
        buffer2.append(elem.getName());
        String value = elem.getValue();
        if (value != null) {
            buffer2.append('=');
            this.doFormatValue(buffer2, value, quote);
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                buffer2.append("; ");
                this.formatNameValuePair(buffer2, elem.getParameter(i), quote);
            }
        }
        return buffer2;
    }

    protected int estimateHeaderElementLen(HeaderElement elem) {
        int parcnt;
        if (elem == null) {
            return 0;
        }
        int result = elem.getName().length();
        String value = elem.getValue();
        if (value != null) {
            result += 3 + value.length();
        }
        if ((parcnt = elem.getParameterCount()) > 0) {
            for (int i = 0; i < parcnt; ++i) {
                result += 2 + this.estimateNameValuePairLen(elem.getParameter(i));
            }
        }
        return result;
    }

    public static String formatParameters(NameValuePair[] nvps, boolean quote, HeaderValueFormatter formatter2) {
        return (formatter2 != null ? formatter2 : INSTANCE).formatParameters(null, nvps, quote).toString();
    }

    @Override
    public CharArrayBuffer formatParameters(CharArrayBuffer charBuffer, NameValuePair[] nvps, boolean quote) {
        Args.notNull(nvps, "Header parameter array");
        int len = this.estimateParametersLen(nvps);
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len);
        } else {
            buffer2.ensureCapacity(len);
        }
        for (int i = 0; i < nvps.length; ++i) {
            if (i > 0) {
                buffer2.append("; ");
            }
            this.formatNameValuePair(buffer2, nvps[i], quote);
        }
        return buffer2;
    }

    protected int estimateParametersLen(NameValuePair[] nvps) {
        if (nvps == null || nvps.length < 1) {
            return 0;
        }
        int result = (nvps.length - 1) * 2;
        for (NameValuePair nvp : nvps) {
            result += this.estimateNameValuePairLen(nvp);
        }
        return result;
    }

    public static String formatNameValuePair(NameValuePair nvp, boolean quote, HeaderValueFormatter formatter2) {
        return (formatter2 != null ? formatter2 : INSTANCE).formatNameValuePair(null, nvp, quote).toString();
    }

    @Override
    public CharArrayBuffer formatNameValuePair(CharArrayBuffer charBuffer, NameValuePair nvp, boolean quote) {
        Args.notNull(nvp, "Name / value pair");
        int len = this.estimateNameValuePairLen(nvp);
        CharArrayBuffer buffer2 = charBuffer;
        if (buffer2 == null) {
            buffer2 = new CharArrayBuffer(len);
        } else {
            buffer2.ensureCapacity(len);
        }
        buffer2.append(nvp.getName());
        String value = nvp.getValue();
        if (value != null) {
            buffer2.append('=');
            this.doFormatValue(buffer2, value, quote);
        }
        return buffer2;
    }

    protected int estimateNameValuePairLen(NameValuePair nvp) {
        if (nvp == null) {
            return 0;
        }
        int result = nvp.getName().length();
        String value = nvp.getValue();
        if (value != null) {
            result += 3 + value.length();
        }
        return result;
    }

    protected void doFormatValue(CharArrayBuffer buffer2, String value, boolean quote) {
        int i;
        boolean quoteFlag = quote;
        if (!quoteFlag) {
            for (i = 0; i < value.length() && !quoteFlag; ++i) {
                quoteFlag = this.isSeparator(value.charAt(i));
            }
        }
        if (quoteFlag) {
            buffer2.append('\"');
        }
        for (i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (this.isUnsafe(ch)) {
                buffer2.append('\\');
            }
            buffer2.append(ch);
        }
        if (quoteFlag) {
            buffer2.append('\"');
        }
    }

    protected boolean isSeparator(char ch) {
        return SEPARATORS.indexOf(ch) >= 0;
    }

    protected boolean isUnsafe(char ch) {
        return UNSAFE_CHARS.indexOf(ch) >= 0;
    }
}

