/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible
    public static <T> T[] newArray(Class<T> type2, int length) {
        return (Object[])Array.newInstance(type2, length);
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @GwtIncompatible
    public static <T> T[] concat(T[] first, T[] second, Class<T> type2) {
        T[] result = ObjectArrays.newArray(type2, first.length + second.length);
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concat(@ParametricNullness T element2, T[] array2) {
        T[] result = ObjectArrays.newArray(array2, array2.length + 1);
        result[0] = element2;
        System.arraycopy(array2, 0, result, 1, array2.length);
        return result;
    }

    public static <T> T[] concat(T[] array2, @ParametricNullness T element2) {
        T[] result = Arrays.copyOf(array2, array2.length + 1);
        result[array2.length] = element2;
        return result;
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array2) {
        int size = c.size();
        if (array2.length < size) {
            array2 = ObjectArrays.newArray(array2, size);
        }
        ObjectArrays.fillArray(c, array2);
        if (array2.length > size) {
            @Nullable T[] unsoundlyCovariantArray = array2;
            unsoundlyCovariantArray[size] = null;
        }
        return array2;
    }

    static <T> T[] toArrayImpl(@Nullable Object[] src, int offset, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, len);
        } else if (dst.length > len) {
            T[] unsoundlyCovariantArray = dst;
            unsoundlyCovariantArray[len] = null;
        }
        System.arraycopy(src, offset, dst, 0, len);
        return dst;
    }

    static @Nullable Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new Object[c.size()]);
    }

    static @Nullable Object[] copyAsObjectArray(@Nullable Object[] elements, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, elements.length);
        if (length == 0) {
            return new Object[0];
        }
        @Nullable Object[] result = new Object[length];
        System.arraycopy(elements, offset, result, 0, length);
        return result;
    }

    @CanIgnoreReturnValue
    private static @Nullable Object[] fillArray(Iterable<?> elements, @Nullable Object[] array2) {
        int i = 0;
        for (Object element2 : elements) {
            array2[i++] = element2;
        }
        return array2;
    }

    static void swap(Object[] array2, int i, int j) {
        Object temp = array2[i];
        array2[i] = array2[j];
        array2[j] = temp;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array2) {
        ObjectArrays.checkElementsNotNull(array2, array2.length);
        return array2;
    }

    @CanIgnoreReturnValue
    static @Nullable Object[] checkElementsNotNull(@Nullable Object[] array2, int length) {
        for (int i = 0; i < length; ++i) {
            ObjectArrays.checkElementNotNull(array2[i], i);
        }
        return array2;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(@CheckForNull Object element2, int index2) {
        if (element2 == null) {
            throw new NullPointerException(new StringBuilder(20).append("at index ").append(index2).toString());
        }
        return element2;
    }
}

