/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.Installer;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.impl.MetadataGeneratorFactory;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallResult;
import org.eclipse.aether.installation.InstallationException;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.metadata.MergeableMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.aether.transform.FileTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultInstaller
implements Installer,
Service {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultInstaller.class);
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private Collection<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    private SyncContextFactory syncContextFactory;

    public DefaultInstaller() {
    }

    @Inject
    DefaultInstaller(FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, Set<MetadataGeneratorFactory> metadataFactories, SyncContextFactory syncContextFactory) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setMetadataGeneratorFactories(metadataFactories);
        this.setSyncContextFactory(syncContextFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setMetadataGeneratorFactories(locator.getServices(MetadataGeneratorFactory.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultInstaller setFileProcessor(FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public DefaultInstaller setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public DefaultInstaller addMetadataGeneratorFactory(MetadataGeneratorFactory factory) {
        this.metadataFactories.add(Objects.requireNonNull(factory, "metadata generator factory cannot be null"));
        return this;
    }

    public DefaultInstaller setMetadataGeneratorFactories(Collection<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    public DefaultInstaller setSyncContextFactory(SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    @Override
    public InstallResult install(RepositorySystemSession session2, InstallRequest request) throws InstallationException {
        try (SyncContext syncContext = this.syncContextFactory.newInstance(session2, false);){
            InstallResult installResult = this.install(syncContext, session2, request);
            return installResult;
        }
    }

    private InstallResult install(SyncContext syncContext, RepositorySystemSession session2, InstallRequest request) throws InstallationException {
        InstallResult result = new InstallResult(request);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        List<? extends MetadataGenerator> generators = this.getMetadataGenerators(session2, request);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(request.getArtifacts());
        IdentityHashMap processedMetadata = new IdentityHashMap();
        List<Metadata> metadatas = Utils.prepareMetadata(generators, artifacts);
        syncContext.acquire(artifacts, Utils.combine(request.getMetadata(), metadatas));
        for (Metadata metadata : metadatas) {
            this.install(session2, trace, metadata);
            processedMetadata.put(metadata, null);
            result.addMetadata(metadata);
        }
        ListIterator<Artifact> iterator = artifacts.listIterator();
        while (iterator.hasNext()) {
            Artifact artifact = (Artifact)iterator.next();
            for (MetadataGenerator metadataGenerator : generators) {
                artifact = metadataGenerator.transformArtifact(artifact);
            }
            iterator.set(artifact);
            this.install(session2, trace, artifact);
            result.addArtifact(artifact);
        }
        metadatas = Utils.finishMetadata(generators, artifacts);
        syncContext.acquire(null, metadatas);
        for (Metadata metadata : metadatas) {
            this.install(session2, trace, metadata);
            processedMetadata.put(metadata, null);
            result.addMetadata(metadata);
        }
        for (Metadata metadata : request.getMetadata()) {
            if (processedMetadata.containsKey(metadata)) continue;
            this.install(session2, trace, metadata);
            result.addMetadata(metadata);
        }
        return result;
    }

    private List<? extends MetadataGenerator> getMetadataGenerators(RepositorySystemSession session2, InstallRequest request) {
        PrioritizedComponents<MetadataGeneratorFactory> factories = Utils.sortMetadataGeneratorFactories(session2, this.metadataFactories);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (PrioritizedComponent<MetadataGeneratorFactory> factory : factories.getEnabled()) {
            MetadataGenerator generator = factory.getComponent().newInstance(session2, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void install(RepositorySystemSession session2, RequestTrace trace, Artifact artifact) throws InstallationException {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        File srcFile = artifact.getFile();
        Collection<FileTransformer> fileTransformers = session2.getFileTransformerManager().getTransformersForArtifact(artifact);
        if (fileTransformers.isEmpty()) {
            this.install(session2, trace, artifact, lrm, srcFile, null);
        } else {
            for (FileTransformer fileTransformer : fileTransformers) {
                this.install(session2, trace, artifact, lrm, srcFile, fileTransformer);
            }
        }
    }

    private void install(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, LocalRepositoryManager lrm, File srcFile, FileTransformer fileTransformer) throws InstallationException {
        Artifact targetArtifact = fileTransformer != null ? fileTransformer.transformArtifact(artifact) : artifact;
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact(targetArtifact));
        this.artifactInstalling(session2, trace, targetArtifact, dstFile);
        Exception exception = null;
        try {
            boolean copy2;
            if (dstFile.equals(srcFile)) {
                throw new IllegalStateException("cannot install " + dstFile + " to same path");
            }
            boolean bl = copy2 = "pom".equals(targetArtifact.getExtension()) || srcFile.lastModified() != dstFile.lastModified() || srcFile.length() != dstFile.length() || !srcFile.exists();
            if (!copy2) {
                LOGGER.debug("Skipped re-installing {} to {}, seems unchanged", (Object)srcFile, (Object)dstFile);
            } else if (fileTransformer != null) {
                try (InputStream is2 = fileTransformer.transformData(srcFile);){
                    this.fileProcessor.write(dstFile, is2);
                    dstFile.setLastModified(srcFile.lastModified());
                }
            } else {
                this.fileProcessor.copy(srcFile, dstFile);
                dstFile.setLastModified(srcFile.lastModified());
            }
            lrm.add(session2, new LocalArtifactRegistration(targetArtifact));
        }
        catch (Exception e2) {
            exception = e2;
            throw new InstallationException("Failed to install artifact " + targetArtifact + ": " + e2.getMessage(), e2);
        }
        finally {
            this.artifactInstalled(session2, trace, targetArtifact, dstFile, exception);
        }
    }

    private void install(RepositorySystemSession session2, RequestTrace trace, Metadata metadata) throws InstallationException {
        LocalRepositoryManager lrm = session2.getLocalRepositoryManager();
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalMetadata(metadata));
        this.metadataInstalling(session2, trace, metadata, dstFile);
        Exception exception = null;
        try {
            if (metadata instanceof MergeableMetadata) {
                ((MergeableMetadata)metadata).merge(dstFile, dstFile);
            } else {
                if (dstFile.equals(metadata.getFile())) {
                    throw new IllegalStateException("cannot install " + dstFile + " to same path");
                }
                this.fileProcessor.copy(metadata.getFile(), dstFile);
            }
            lrm.add(session2, new LocalMetadataRegistration(metadata));
        }
        catch (Exception e2) {
            exception = e2;
            throw new InstallationException("Failed to install metadata " + metadata + ": " + e2.getMessage(), e2);
        }
        finally {
            this.metadataInstalled(session2, trace, metadata, dstFile, exception);
        }
    }

    private void artifactInstalling(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, File dstFile) {
        RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_INSTALLING);
        event2.setTrace(trace);
        event2.setArtifact(artifact);
        event2.setRepository(session2.getLocalRepositoryManager().getRepository());
        event2.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event2.build());
    }

    private void artifactInstalled(RepositorySystemSession session2, RequestTrace trace, Artifact artifact, File dstFile, Exception exception) {
        RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.ARTIFACT_INSTALLED);
        event2.setTrace(trace);
        event2.setArtifact(artifact);
        event2.setRepository(session2.getLocalRepositoryManager().getRepository());
        event2.setFile(dstFile);
        event2.setException(exception);
        this.repositoryEventDispatcher.dispatch(event2.build());
    }

    private void metadataInstalling(RepositorySystemSession session2, RequestTrace trace, Metadata metadata, File dstFile) {
        RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_INSTALLING);
        event2.setTrace(trace);
        event2.setMetadata(metadata);
        event2.setRepository(session2.getLocalRepositoryManager().getRepository());
        event2.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event2.build());
    }

    private void metadataInstalled(RepositorySystemSession session2, RequestTrace trace, Metadata metadata, File dstFile, Exception exception) {
        RepositoryEvent.Builder event2 = new RepositoryEvent.Builder(session2, RepositoryEvent.EventType.METADATA_INSTALLED);
        event2.setTrace(trace);
        event2.setMetadata(metadata);
        event2.setRepository(session2.getLocalRepositoryManager().getRepository());
        event2.setFile(dstFile);
        event2.setException(exception);
        this.repositoryEventDispatcher.dispatch(event2.build());
    }
}

