<img src="images/logo-dark.svg" width="180" align="right">

![CI](https://img.shields.io/github/workflow/status/clojure-lsp/clojure-lsp/CI?style=flat-square)
[![Clojars Project](https://img.shields.io/clojars/v/com.github.clojure-lsp/clojure-lsp.svg)](https://clojars.org/com.github.clojure-lsp/clojure-lsp)
[![cljdoc](https://cljdoc.org/badge/com.github.clojure-lsp/clojure-lsp)](https://cljdoc.org/d/com.github.clojure-lsp/clojure-lsp)
[![Slack community](https://img.shields.io/badge/Slack-chat-blue?style=flat-square)](https://clojurians.slack.com/archives/CPABC1H61)
[![Github stars](https://img.shields.io/github/stars/clojure-lsp/clojure-lsp?style=social)](https://github.com/clojure-lsp/clojure-lsp)

# clojure-lsp

A [Language Server](https://microsoft.github.io/language-server-protocol/) for Clojure(script). Taking a Cursive-like approach of statically analyzing code.

<hr>
<p align="center">
  <a href="https://clojure-lsp.io"><strong>homepage</strong></a> •
  <a href="https://clojure-lsp.io/features/"><strong>features</strong></a> •
  <a href="https://clojure-lsp.io/installation/"><strong>installation</strong></a> •
  <a href="https://clojure-lsp.io/settings"><strong>settings</strong></a> •
  <a href="https://clojure-lsp.io/clients"><strong>clients</strong></a> •
  <a href="https://clojure-lsp.io/troubleshooting"><strong>troubleshooting</strong></a> •
  <a href="https://github.com/sponsors/clojure-lsp"><strong>support us</strong></a>
</p>
<hr>

## Overview 

The goal of this project is to bring great editing tools for Clojure/Clojurescript to all editors and programatically via its CLI and API.
It aims to work alongside you to help you navigate, identify and fix errors, perform refactors and much more!

You will get:

- **Autocomplete**
- **Jump to definition/implementation**
- **Find references**
- **Renaming**
- **Code actions**
- **Errors**
- **Automatic ns cleaning**
- **Lots of Refactorings**
- **Code lens**
- **Semantic tokens (syntax highlighting)**
- **Call hierarchy**
- **Java interop**

For all available documentation, check the official [website](https://clojure-lsp.io/).

Also, clojure-lsp doesn't need to run only with an editor, for more information check the [Outside editor (API)](https://clojure-lsp.io/api/what-is-it) section.

---
## Contribution

Contributions to `clojure-lsp` are very welcome! You can open an issue or a PR and we will love to help.

---
## Support the project

`clojure-lsp` has more than __30.000__ lines of code, to keep all of this working, we need to help the community with a lot of issues and implement new features. As a LSP server, this project is the base for Clojure clients like Emacs(lsp-mode), VSCode(Calva), vim and other editors.

You can help us keep going and improving it by **[supporting the project](https://github.com/sponsors/clojure-lsp)**, the support helps to keep the project going and being updated and maintained.

:rocket: Thank you to [Clojurists Together](https://www.clojuriststogether.org/) which [sponsored this project during Q3 2021](https://www.clojuriststogether.org/news/q3-2021-funding-announcement/) and [Q1 2022](https://www.clojuriststogether.org/news/q1-2022-funding-announcement/) :rocket:

### Gold sponsors

<table id="github-sponsors">
  <tr>
    <td align="center">
      <div>
        <a href="https://github.com/pitch-io">
          <img src="https://github.com/pitch-io.png" width="100px;" style="border-radius: 50%;" alt="pitch-io"/>
          <br/>
          <sub><b>pitch-io</b></sub>
        </a>
        <br/>
         Pitch
      </div>
    </td>
    <td align="center">
      <div>
        <a href="https://github.com/180seg">
          <img src="https://github.com/180seg.png" width="100px;" style="border-radius: 50%;" alt="180seg"/>
          <br/>
          <sub><b>180seg</b></sub>
        </a>
        <br/>
         180º Insurance
      </div>
    </td>
  </tr>
</table>

### Sponsors

[![](https://opencollective.com/clojure-lsp/tiers/sponsor.svg)](https://opencollective.com/clojure-lsp)

[![](https://opencollective.com/clojure-lsp/tiers/backer.svg)](https://opencollective.com/clojure-lsp)

_Special thanks to [Eccentric-J](https://eccentric-j.com/) for the `clojure-lsp` logo_
