#!/usr/local/bin/perl
# -*- perl -*-
#
# Author: Jeremy Kister - http://www.jeremykister.com
# need hosting, colo, or other Internet access?  check out http://www.nntx.net

use DBI;

($name,$passwd,$uid,$gid,$quota,$comment,$gcos,$homedir,$shell) = getpwnam(argus);

$dir="/export/home/config/routers";
opendir (DIR, "$dir") || die "couldnt open dir: $!\n";
	@subdirs=readdir(DIR);
closedir DIR;

foreach( @subdirs ){
	next if( /^\./ || $_ eq "Override" );
	$subdir=$_;
	opendir(DIR, "$dir/$subdir")|| die "cannot open dir: $dir/$_: $!\n";
		foreach( sort readdir(DIR) ){
			$last=$_;
		}
		push @files, "$dir/$subdir/$last";
	closedir DIR;
}

open (C, ">$homedir/tmp/011_customer_conn") || die "cannot open 011 for writing: $!\n";
print C "\n",
        "Group \"Customer Connectivity\" \{\n",
	"\toverrideable:\tno\n",
        "\tautogenerated:\tyes\n",
	"\tacl_staff: connectivity_override\n",
        "\tfrequency:\t180\n",
        "\tsiren:\tno\n";

foreach( @files ){
	next if( /\/\./ || $_ eq "Override" );
	$file=$_;
	$file =~ /.+\/(.+-.+-\d{4}-\d{02})\//;
	 $router = $1;

	open(F, "$file")|| die "cannot open $file: $!\n";
	$/ = '!';
	while(<F>){
		next if( /shutdown/ );
		if( /interface\s((Serial|Multilink)\d\S*)\n\s(description\s.+\n\s)?ip\saddress\s(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s/ ){
			$interface=$1;
			$desctype=$2;
			$maybedescription=$3;
			$ourip=$4;

			if( $interface =~ /^Serial\d+\/\d+\/\d+\:\d+$/ ){
				$type = "T1";
			}elsif( $interface =~ /^Serial\d+\/\d+$/ ){
				$type = "T3";
			}elsif( $interface =~ /^Multilink\d+$/ ){
				$type = "Multilink PPP";
			}

			if( $maybedescription ){
				$maybedescription =~ /^description\s(.+)\n\s$/;
				$description = $1;
			}else{
				$description = "UNKNOWN";
			}

			next if( $description =~ /no-monitor/ );

			$type = "T1" if( $description =~ /\s?[TD]s?-?1\s?/i );
			$type = "T3" if( $description =~ /\s?[TD]s?-?3\s?/i );
			
			$label=$description;

			($oct1,$oct2,$oct3,$oct4) = split /\./, $ourip;
			# monitor our side if the description has monitor-local
			# (for customers with firewalls/whatever)
			if( $description =~ /monitor-local/ ){
				# leave ip alone - we are monitoring our end
				# modify description
				$description .= " <BR><B>monitoring local interface due to customer firewall</b>";
			}else{
				# if ip we have is odd, increment, if even decrement.
				if( $oct4 % 2 ){
					$oct4++;
				}else{
					$oct4--;
				}
			}

			$theirip="$oct1.$oct2.$oct3.$oct4";
		
			$label =~ s/\|.*//;
			$label =~ s/\[.*\]//;
			$label =~ s/(([Tt]|[Dd][Ss])-*[13]|[Mm]ultilink)\s*([Tt][Oo]\s*)?//;
			$label =~ s/WAN//;
			$label =~ s/monitor-local//;
			$label =~ s/^\s+//;
			$label =~ s/\s+$//;
			$label =~ s/#//;
	
			# next one has to be last
			$label =~ s/(\S+)/\u$1/g;

			if( ! $label ){ $label = "UNKNOWN" };
			$label = "[" . "$label" . "]";
			push @$type, "\t\tService Ping \{\n",
			        "\t\t\tlabel: $label\n",
			        "\t\t\thostname:\t$theirip\n",
			        "\t\t\tnote:\t$router:$interface $description\n",
			        "\t\t\tsendnotify: no\n",
				"\t\t\}\n";

			# put new interfaces in automatic override for 30 days
			$type =~ s/\ /_/g;
			$stats="$homedir/stats/Top:Customer_Connectivity:$type:Ping_$theirip";
			if(! -f $stats){
				$start=$^T;
				$stop=($start + 2592000);
				open (S, ">$stats") || die "cannot write to $stats: $!\n";
				print S "status down override $^T $^T\n",
				        "override *Argus* auto $start $stop _ not~x20up~x20yet\n";
				close S;

				chown($uid,$gid,"$stats");
			}
		}
	}
	close F;
	$/ = "\n";
}

foreach $type ('T1','T3','Multilink PPP'){
	print C "\tGroup \"$type\" \{\n";
	foreach(@$type){
		print C;
	}
	print C "\t\}\n";
}


print C "\}\n";
close C;
rename ("$homedir/tmp/011_customer_conn", "$homedir/config/011_customer_conn") || die "cannot rename: $!\n";
