% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\docType{class}
\name{sparseLRMatrix-class}
\alias{sparseLRMatrix-class}
\title{Sparse plus low rank matrix}
\description{
Eventually this class will subclass \code{Matrix} objects,
but for now this is a basic implementation that essentially
only supports singular value decomposition.
}
\details{
To learn more about S4 classes, please see
\url{https://adv-r.hadley.nz/s4.html}.
}
\section{Slots}{

\describe{
\item{\code{sparse}}{sparseMatrix.}

\item{\code{U}}{Matrix.}

\item{\code{V}}{Matrix.}
}}

\examples{

set.seed(528491)

n <- 50
m <- 40
k <- 3

A <- rsparsematrix(n, m, 0.1)

U <- Matrix(rnorm(n * k), nrow = n, ncol = k)
V <- Matrix(rnorm(m * k), nrow = m, ncol = k)

# construct the matrix, which represents A + U \%*\% t(V)
X <- sparseLRMatrix(sparse = A, U = U, V = V)

dim(X)

s <- svds(X, 5)  # efficient

}
