% Generated by roxygen2 (4.0.2): do not edit by hand
\name{peek_front<-.rdeque}
\alias{peek_front<-.rdeque}
\title{Assign to/modify the front of an rdeque}
\usage{
\method{peek_front}{rdeque}(x, ...) <- value
}
\arguments{
\item{x}{rdeque to modify the front element of.}

\item{...}{additional arguments to be passed to or from methods (ignored).}

\item{value}{value to assign to the front data element.}
}
\value{
modified rdeque.
}
\description{
Allows modification access to the front of a deque.
}
\details{
Runs in \eqn{O(1)} worst case time. Throws an error if the rdeque is \code{\link{empty}}. Modifies the element in place (i.e., is not side-effect-free).
}
\examples{
d <- rdeque()
d <- insert_front(d, data.frame(a = 1, b = 1))
d <- insert_front(d, data.frame(a = 1, b = 1))

peek_front(d)$a <- 100
print(d)

peek_front(d) <- data.frame(a = 100, b = 100)
print(d)
}
\seealso{
\code{\link{peek_front.rdeque}} for accessing the front data element.
}

