% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{partition_table}
\alias{partition_table}
\alias{partition_table.array}
\alias{partition_table.AbstractLazyArray}
\title{Generate partition summary statistics for array objects along the last 
dimension}
\usage{
partition_table(x, na.rm = FALSE, ...)

\method{partition_table}{array}(x, na.rm = FALSE, ...)

\method{partition_table}{AbstractLazyArray}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{an array or \code{LazyArray}}

\item{na.rm}{whether to remove \code{NA} when calculating summary statistics}

\item{...}{passed to other methods or ignored}
}
\value{
A data frame with the following possible columns: \code{Min}, 
\code{Max}, \code{Mean}, \code{Standard Deviation}, \code{NAs} (total number
 of \code{NA}), and \code{Length}.
}
\description{
Generate partition summary statistics for array objects along the last 
dimension
}
\examples{

# R array
x <- array(1:27, c(3,3,3))
partition_table(x)

# LazyArray
x <- lazyarray(tempfile(), storage_format = 'double', dim = c(3,3,3))
x[] <- 1:27
partition_table(x, quiet=TRUE)

}
