% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{crossprod}
\alias{crossprod}
\alias{crossprod,AbstractLazyArray,AbstractLazyArray-method}
\alias{crossprod,AbstractLazyArray,NULL-method}
\alias{crossprod,AbstractLazyArray,missing-method}
\alias{crossprod,AbstractLazyArray,matrix-method}
\title{Matrix Crossproduct}
\usage{
\S4method{crossprod}{AbstractLazyArray,AbstractLazyArray}(x, y = NULL, weights = NULL, ...)

\S4method{crossprod}{AbstractLazyArray,`NULL`}(x, y = NULL, weights = NULL, ...)

\S4method{crossprod}{AbstractLazyArray,missing}(x, y = NULL, weights = NULL, ...)

\S4method{crossprod}{AbstractLazyArray,matrix}(x, y = NULL, weights = NULL, ...)
}
\arguments{
\item{x}{a \code{LazyArray} or an R matrix}

\item{y}{\code{NULL} or matrix}

\item{weights}{numeric vector used as weight}

\item{...}{passed to further methods}
}
\value{
Matrix of cross product if data is small, or \code{LazyMatrix} if
matrix is too large
}
\description{
Matrix Crossproduct
}
\examples{

x <- matrix(1:100, 50)
crossprod(x)

lazy_x <- as.lazymatrix(x)
crossprod(lazy_x)[]

weights <- (1:50)/50

t(x) \%*\% diag(weights) \%*\% x
crossprod(lazy_x, weights = weights)

\dontrun{

# large data set ~ 1.6GB
x <- as.lazymatrix(matrix(rnorm(2e8), ncol = 2))

crossprod(x)
}


}
