% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{chunk_map}
\alias{chunk_map}
\title{Apply functions to all partitions, but small chunks each time}
\usage{
chunk_map(x, map_fun, reduce, max_nchunks, chunk_size, ...)
}
\arguments{
\item{x}{a \code{LazyArray} or R array}

\item{map_fun}{function to apply to each chunk}

\item{reduce}{similar to \code{reduce} in \code{\link{partition_map}}}

\item{max_nchunks}{maximum number of chunks. If number of chunks is too 
large, then \code{chunk_size} will be re-calculated.}

\item{chunk_size}{integer chunk size. If \code{chunk_size} is too small, it 
will be ignored}

\item{...}{ignored or passed to other methods}
}
\value{
If \code{reduce} is missing, returns a list of results. Each result
is returned by \code{map_fun}, and the total length equals to number of 
chunks mapped. If \code{reduce} is a function, that list of results will
be passed to \code{reduce} and \code{chunk_map} returns the results 
generated from \code{reduce}.
}
\description{
Apply functions to all partitions, but small chunks each time
}
\details{
The difference between \code{chunk_map} and 
\code{partition_map} is the margin or direction to apply mapping
functions. In \code{partition_map}, mapping function is applied to 
each partition. If \code{x} is a matrix, this means applying to each column.
\code{chunk_map} generate small chunks along all dimensions except the last,
and apply mapping functions to each chunks. If \code{x} is a matrix, it 
make chunks along rows and apply mapping functions along rows.
}
\examples{

x <- as.lazymatrix(matrix(1:100, ncol = 2))
x

# Set max_nchunks=Inf and chunk_size=10 to force total number of chunks
# is around nrow(x)/10 and each chunk contains at most 10 rows
chunk_map(x, function(chunk){chunk[1:2,]}, chunk_size = 10, max_nchunks = Inf)

# For each chunks, calculate mean, then calculate the mean of chunk mean
chunk_map(x, function(chunk) {
  colMeans(chunk)
}, function(chunk_means) {
  Reduce('+', chunk_means) / length(chunk_means)
})

colMeans(x[])


}
\seealso{
\code{\link{partition_map}}
}
