% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop.R
\name{pop}
\alias{pop}
\alias{pop,CppStack-method}
\alias{pop,CppQueue-method}
\alias{pop,CppPriorityQueue-method}
\title{Remove top element}
\usage{
pop(x)
}
\arguments{
\item{x}{A CppStack, CppQueue, or CppPriorityQueue object.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Remove top element in a stack or priority queue or the first element in a queue by reference.
}
\details{
In a stack, it is the last inserted element. In a queue, it is the first inserted element. In a descending (ascending) priority queue, it is 
the largest (smallest) value.
}
\examples{
s <- cpp_stack(4:6)
s
# Top element: 6

pop(s)
s
# Top element: 5

q <- cpp_queue(4:6)
q
# First element: 4

pop(q)
q
# First element: 5

p <- cpp_priority_queue(4:6)
p
# First element: 6

pop(p)
p
# First element: 5

}
\seealso{
\link{back}, \link{emplace}, \link{front}, \link{push}, \link{top}.
}
