% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge}
\alias{merge}
\alias{merge,CppSet,CppSet-method}
\alias{merge,CppUnorderedSet,CppUnorderedSet-method}
\alias{merge,CppMultiset,CppMultiset-method}
\alias{merge,CppUnorderedMultiset,CppUnorderedMultiset-method}
\alias{merge,CppMap,CppMap-method}
\alias{merge,CppUnorderedMap,CppUnorderedMap-method}
\alias{merge,CppMultimap,CppMultimap-method}
\alias{merge,CppUnorderedMultimap,CppUnorderedMultimap-method}
\alias{merge,CppForwardList,CppForwardList-method}
\alias{merge,CppList,CppList-method}
\title{Merge two objects}
\usage{
merge(x, y, ...)
}
\arguments{
\item{x}{A CppSet, CppUnorderedSet, CppMultiset, CppUnorderedMultiset, CppMap, CppUnorderedMap, CppMultimap, CppUnorderedMultimap, CppForwardList, or 
CppList object.}

\item{y}{A CppSet, CppUnorderedSet, CppMultiset, CppUnorderedMultiset, CppMap, CppUnorderedMap, CppMultimap, CppUnorderedMultimap, CppForwardList, or 
CppList object of the same class and data type as \code{x}.}

\item{...}{Ignored. Only included for compatibility with generic \code{base::merge} method.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Merge two objects by reference.
}
\details{
In containers enforcing uniqueness (CppSet, CppUnorderedSet, CppMap, CppUnorderedMap), the function merges elements from \code{y} that are not 
in \code{x} into \code{x} and deletes them from \code{y}. In other container types, it transfers all elements.
}
\examples{
x <- cpp_set(c("hello", "there"))
y <- cpp_set(c("hello", "world"))

merge(x, y)
x
# "hello" "there" "world"
y
# "hello"

x <- cpp_forward_list(c(1, 3, 4, 3))
y <- cpp_forward_list(c(2, 3, 5))

merge(x, y)
x
# 1 2 3 3 4 3 5
y
# 

}
\seealso{
\link{assign}, \link{emplace}, \link{insert}.
}
