% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capacity.R
\name{capacity}
\alias{capacity}
\alias{capacity,CppVector-method}
\title{Get container capacity}
\usage{
capacity(x)
}
\arguments{
\item{x}{A CppVector object.}
}
\value{
Returns a numeric.
}
\description{
Get the capacity of a CppVector.
}
\details{
The capacity is the space reserved for the vector, which can exceed its \link{size}. Additional capacity ensures that the vector can be 
extended efficiently, without having to reallocate its current elements to a new memory location.
}
\examples{
v <- cpp_vector(4:9)
v
# 4 5 6 7 8 9

capacity(v)
# [1] 6

reserve(v, 20)
size(v)
#[1] 6
capacity(v)
# [1] 20

v
# 4 5 6 7 8 9

}
\seealso{
\link{reserve}, \link{shrink_to_fit}, \link{size}.
}
