% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acquireConn.R
\name{acquireConn}
\alias{acquireConn}
\alias{releaseConn}
\title{Acquire the SQL file connection}
\usage{
acquireConn(path, dbtype = NULL)

releaseConn(path)
}
\arguments{
\item{path}{String containing a path to a SQL file.}

\item{dbtype}{String containing the SQL database type (case
insensitive). Supported types are "SQLite" and "DuckDB".}
}
\value{
For \code{acquireConn}, a DBIConnection with backends of
    SQLite or DuckDB, which are identical to that returned by
    \code{DBI::dbConnect(RSQLite::SQLite(), path)} or
    \code{DBI::dbConnect(duckdb::duckdb(), path)}.

For \code{releaseConn}, any existing DBIConnection for the
\code{path} is disconnected and cleared from cache, and \code{NULL}
is invisibly returned. If \code{path=NULL}, all cached connections
are removed.
}
\description{
Acquire a (possibly cached) SQL file connection given it's path.
}
\details{
\code{acquireConn} will cache the DBIConnection object in
    the current R session to avoid repeated initialization. This
    improves efficiency for repeated calls, e.g., when creating a
    \linkS4class{DataFrame} with multiple columns from the same SQL
    table. The cached DBIConnection for any given \code{path} can
    be deleted by calling \code{releaseConn} for the same
    \code{path}.
}
\examples{

###########
## SQLite
###########

## Mocking up a file
tf <- tempfile()
on.exit(unlink(tf))
con <- DBI::dbConnect(RSQLite::SQLite(), tf)
DBI::dbWriteTable(con, "mtcars", mtcars)
DBI::dbDisconnect(con)

## Acquire or release connection
con <- acquireConn(tf, dbtype = "SQLite")
acquireConn(tf, dbtype = "SQLite") # just re-uses the cache
releaseConn(tf) # clears the cache

###########
## DuckDB
###########

tf1 <- tempfile()
on.exit(unlist(tf1))
con <- DBI::dbConnect(duckdb::duckdb(), tf1)
DBI::dbWriteTable(con, "mtcars", mtcars)
DBI::dbDisconnect(con)
con <- acquireConn(tf1, dbtype = "DuckDB")
releaseConn(tf1)

}
\author{
Qian Liu
}
