% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valleys.R
\name{valleys}
\alias{valleys}
\title{Find Peak Valleys}
\usage{
valleys(x, p)
}
\arguments{
\item{x}{\code{numeric}, e.g. intensity values.}

\item{p}{\code{integer}, indices of identified peaks/local maxima.}
}
\value{
A \code{matrix} with three columns representing the index of the left
valley, the peak centroid, and the right valley.
}
\description{
This function finds the valleys around peaks.
}
\note{
The detection of the valleys is based on \code{\link{localMaxima}}. It returns the
\emph{first} occurence of a local maximum (in this specific case the minimum).
For plateaus, e.g. \code{c(0, 0, 0, 1:3, 2:1, 0)} this results in a wrongly
reported left valley index of \code{1} (instead of \code{3}, see the example section as
well). In real data this should not be a real problem.
\code{x[x == min(x)] <- Inf} could be used before running \code{valleys} to circumvent
this specific problem but it is not really tested and could cause different
problems.
}
\examples{
ints <- c(5, 8, 12, 7, 4, 9, 15, 16, 11, 8, 3, 2, 3, 2, 9, 12, 14, 13, 8, 3)
mzs <- seq_along(ints)
peaks <- which(localMaxima(ints, hws = 3))
cols <- seq_along(peaks) + 1

plot(mzs, ints, type = "h", ylim = c(0, 16))
points(mzs[peaks], ints[peaks], col = cols, pch = 20)

v <- valleys(ints, peaks)
segments(mzs[v[, "left"]], 0, mzs[v[, "right"]], col = cols, lwd = 2)

## Known limitations for plateaus
y <- c(0, 0, 0, 0, 0, 1:5, 4:1, 0)
valleys(y, 10L) # left should be 5 here but is 1

## a possible workaround that may cause other problems
y[min(y) == y] <- Inf
valleys(y, 10L)
}
\seealso{
Other extreme value functions: 
\code{\link{.peakRegionMask}()},
\code{\link{localMaxima}()},
\code{\link{refineCentroids}()}
}
\author{
Sebastian Gibb
}
\concept{extreme value functions}
