% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_by_vector.R
\name{medianPolish}
\alias{medianPolish}
\title{Return the Median Polish (Robust Twoway Decomposition) of a matrix}
\usage{
medianPolish(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A \code{matrix} of mode \code{numeric}.}

\item{verbose}{Default is \code{FALSE}.}

\item{...}{Additional arguments passed to \code{\link[stats:medpolish]{stats::medpolish()}}.}
}
\value{
A \code{numeric} vector of length identical to \code{ncol(x)}.
}
\description{
Fits an additive model (two way decomposition) using Tukey's median
polish procedure using \code{\link[stats:medpolish]{stats::medpolish()}}.
}
\examples{
x <- matrix(rnorm(30), nrow = 3)
medianPolish(x)
}
\seealso{
Other Quantitative feature aggregation: 
\code{\link{aggregate}()},
\code{\link{colCounts}()},
\code{\link{robustSummary}()}
}
\author{
Laurent Gatto
}
\concept{Quantitative feature aggregation}
