% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.R
\name{group}
\alias{group}
\title{Grouping of numeric values by similarity}
\usage{
group(x, tolerance = 0, ppm = 0)
}
\arguments{
\item{x}{increasingly ordered \code{numeric} with the values to be grouped.}

\item{tolerance}{\code{numeric(1)} with the maximal accepted difference between
values in \code{x} to be grouped into the same entity.}

\item{ppm}{\code{numeric(1)} defining a value-dependent maximal accepted
difference between values in \code{x} expressed in parts-per-million.}
}
\value{
\code{integer} of length equal to \code{x} with the groups.
}
\description{
The \code{group} function groups numeric values by first ordering and then putting
all values into the same group if their difference is smaller defined by
parameters \code{tolerance} (a constant value) and \code{ppm} (a value-specific
relative value expressed in parts-per-million).
}
\note{
Since grouping is performed on pairwise differences between consecutive
values (after ordering \code{x}), the difference between the smallest and largest
value in a group can be larger than \code{tolerance} and \code{ppm}.
}
\examples{

## Define a (sorted) numeric vector
x <- c(34, 35, 35, 35 + ppm(35, 10), 56, 56.05, 56.1)

## With `ppm = 0` and `tolerance = 0` only identical values are grouped
group(x)

## With `tolerance = 0.05`
group(x, tolerance = 0.05)

## Also values 56, 56.05 and 56.1 were grouped into a single group,
## although the difference between the smallest 56 and largest value in
## this group (56.1) is 0.1. The (pairwise) difference between the ordered
## values is however 0.05.

## With ppm
group(x, ppm = 10)

## Same on an unsorted vector
x <- c(65, 34, 65.1, 35, 66, 65.2)
group(x, tolerance = 0.1)

## Values 65, 65.1 and 65.2 have been grouped into the same group.
}
\author{
Johannes Rainer, Sebastin Gibb
}
