% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomUnifArray-class.R
\docType{class}
\name{RandomUnifArray-class}
\alias{RandomUnifArray-class}
\alias{RandomUnifArraySeed-class}
\alias{RandomUnifMatrix-class}
\alias{sampleDistrParam,RandomUnifArraySeed-method}
\alias{sampleDistrFun,RandomUnifArraySeed-method}
\alias{matrixClass,RandomUnifArray-method}
\alias{RandomUnifArraySeed}
\alias{DelayedArray,RandomUnifArraySeed-method}
\alias{RandomUnifArray}
\title{DelayedArray of random uniform values}
\usage{
RandomUnifArraySeed(dim, min = 0, max = 1, chunkdim = NULL)

\S4method{DelayedArray}{RandomUnifArraySeed}(seed)

RandomUnifArray(dim, min = 0, max = 1, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{min, max}{Numeric vector used as \code{min} and \code{max}, respectively, in \code{\link{qunif}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomUnifArraySeed object.}
}
\value{
All constructors return an instance of a RandomUnifArray object,
containing random draws from a uniform distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of uniformly distributed values.
}
\examples{
X <- RandomUnifArraySeed(c(1e5, 1e5))
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomUnifArraySeed(c(1e5, 1e5), min=1:1e5, max=1:1e5*2)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
min <- rsparsematrix(1e5, 1e5, density=0.00001)
X3 <- RandomUnifArraySeed(c(1e5, 1e5), min=min, max=DelayedArray(min)+1)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
