% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomTArray-class.R
\docType{class}
\name{RandomTArray-class}
\alias{RandomTArray-class}
\alias{RandomTArraySeed-class}
\alias{RandomTMatrix-class}
\alias{sampleDistrParam,RandomTArraySeed-method}
\alias{sampleDistrFun,RandomTArraySeed-method}
\alias{matrixClass,RandomTArray-method}
\alias{extract_array,RandomTArraySeed-method}
\alias{RandomTArraySeed}
\alias{DelayedArray,RandomTArraySeed-method}
\alias{RandomTArray}
\title{DelayedArray of random F-distributed values}
\usage{
RandomTArraySeed(dim, df, ncp, chunkdim = NULL)

\S4method{DelayedArray}{RandomTArraySeed}(seed)

RandomTArray(dim, df, ncp, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{df, ncp}{Numeric vector used as the argument of the same name in \code{\link{qf}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.

If \code{ncp} is missing, a central T distribution is assumed.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomTArraySeed object.}
}
\value{
All constructors return an instance of a RandomTArray object,
containing random draws from a exponential distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of F-distributed values.
}
\examples{
X <- RandomTArraySeed(c(1e5, 1e5), df=10)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomTArraySeed(c(1e5, 1e5), df=sample(20, 1e5, replace=TRUE))
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
ncp <- rsparsematrix(1e5, 1e5, density=0.00001)
ncp <- abs(DelayedArray(ncp)) + 1
X3 <- RandomTArraySeed(c(1e5, 1e5), df=10, ncp=ncp)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
