% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomBetaArray-class.R
\docType{class}
\name{RandomBetaArray-class}
\alias{RandomBetaArray-class}
\alias{RandomBetaArraySeed-class}
\alias{RandomBetaMatrix-class}
\alias{sampleDistrParam,RandomBetaArraySeed-method}
\alias{sampleDistrFun,RandomBetaArraySeed-method}
\alias{extract_array,RandomBetaArraySeed-method}
\alias{matrixClass,RandomBetaArray-method}
\alias{RandomBetaArraySeed}
\alias{DelayedArray,RandomBetaArraySeed-method}
\alias{RandomBetaArray}
\title{DelayedArray of random beta-distributed values}
\usage{
RandomBetaArraySeed(dim, shape1, shape2, ncp = 0, chunkdim = NULL)

\S4method{DelayedArray}{RandomBetaArraySeed}(seed)

RandomBetaArray(dim, shape1, shape2, ncp = 0, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{shape1, shape2, ncp}{Numeric vector used as the argument of the same name in \code{\link{qbeta}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomBetaArraySeed object.}
}
\value{
All constructors return an instance of a RandomBetaArray object,
containing random draws from a beta distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of beta-distributed values.
}
\examples{
X <- RandomBetaArraySeed(c(1e5, 1e5), shape1=1, shape2=10)
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomBetaArraySeed(c(1e5, 1e5), shape1=runif(1e5), shape2=2)
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
s1 <- rsparsematrix(1e5, 1e5, density=0.00001)
s1 <- abs(DelayedArray(s1)) + 1
X3 <- RandomBetaArraySeed(c(1e5, 1e5), shape1=s1, shape2=s1+1)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
