% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BootGOFTestLM.R
\name{BootGOFTestLM}
\alias{BootGOFTestLM}
\alias{print.BootGOFTestLM}
\title{Bootstrap goodness-of-fit procedure for linear models}
\usage{
BootGOFTestLM(
  x,
  data,
  boot_iter = 1000,
  level = 0.95,
  return_dist = FALSE,
  ...
)

\method{print}{BootGOFTestLM}(x, ...)
}
\arguments{
\item{x}{A fitted \code{lm} object.}

\item{data}{A dataframe used to fit the model given by \code{x}.}

\item{boot_iter}{An integer indicating number of bootstrap iterations to perform.}

\item{level}{Confidence level of the bootstrap interval used in the test.}

\item{return_dist}{A logical specifying whether to optionally return the bootstrap distribution. Defaults to FALSE.}

\item{...}{Additional arguments.}
}
\value{
A list containing the specification and results of the test. The hypothesis of adequate fit is rejected if the null value is not contained in the bootstrap interval.
}
\description{
Performs a bootstrap goodness-of-fit procedure to assess the fit of a normal linear regression model
}
\examples{
# generate some data
set.seed(5122023)
data <- data.frame(s = rnorm(200), t = rnorm(200))
data$y <- data$s + rnorm(200)
# determine whether candidate model shows lack of fit
model <- lm(y~s+t, data = data)
BootGOFTestLM(model, data = data, booot_iter = 100)

}
