/*
    ProjectModuleLoader.m

    Implementation of the ProjectModuleLoader class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import "ProjectModuleLoader.h"

#import <Foundation/NSDictionary.h>
#import <Foundation/NSArray.h>
#import <Foundation/NSBundle.h>
#import <Foundation/NSDebug.h>

#import "ProjectModule.h"
#import "BundleExtensionLoader.h"

@implementation ProjectModuleLoader

static ProjectModuleLoader * shared = nil;

+ shared
{
  if (shared == nil)
    {
      shared = [self new];
    }

  return shared;
}

- init
{
  if ((self = [super init]) != nil)
    {
      /* load all project type bundles */

      NSMutableDictionary * projModules;
      NSArray * bundles;
      NSBundle * bundle;
      NSEnumerator * e;

      bundles = [[BundleExtensionLoader shared]
        extensionsForBundleType: @"projmodule"
         principalClassProtocol: @protocol(ProjectModule)
             bundleSubdirectory: @"ProjectManager"
                      inDomains: 0
           domainDetectionByKey: @"ProjectModules"];

      projModules = [NSMutableDictionary dictionaryWithCapacity:
        [bundles count]];

      e = [bundles objectEnumerator];
      while ((bundle = [e nextObject]) != nil)
        {
          Class principalClass = [bundle principalClass];
          NSString * moduleName = [principalClass moduleName];

          NSDebugLLog(@"ProjectModuleLoader", _(@"Loaded project module: "
            @"%@ -> (Class) %@"), moduleName, principalClass);

          [projModules setObject: principalClass
                          forKey: moduleName];
        }

      ASSIGNCOPY(projectModules, projModules);
    }

  return self;
}

- (NSDictionary *) projectModules
{
  return projectModules;
}

- (id <ProjectModule>)
  projectModuleForModuleName: (NSString *) projectModuleName
                     project: (ProjectDocument *) project
              infoDictionary: (NSDictionary *) infoDict
{
  Class projModule;

  projModule = [projectModules objectForKey: projectModuleName];

  return [[[projModule alloc]
    initWithDocument: project
      infoDictionary: infoDict]
    autorelease];
}

@end
