/*
    ProjectCreator.h

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>


@class WKWizardPanel;

@class NSDictionary,
       NSString,
       NSOutlineView,
       NSTableColumn,
       NSView,
       NSError;

extern NSString * const ProjectCreatorErrorDomain;
enum {
  ProjectFileImportError,
  ProjectDirectoryCreationError
};

@interface ProjectCreator : NSObject
{
  WKWizardPanel * wizard;

  id projectNameCell,
     projectNameForm,
     projectNameNotice,
     projectNameMistake,
     projectNameView,
     projectTypes,
     projectTypeView,
     projectTypeIcon,
     projectTypeDescription,
     window1,
     window2,
     templateNeededNotice;

  id finishButton,
     backToLocationButton,
     toProjectTypeSelectionButton;

  // an array of ProjectTypeDescription objects
  NSArray * projectTypesCache;

  NSString * location;
  NSString * projectName;
}

+ shared;

+ (BOOL) createNewProjectAtPath: (NSString *) aProjectPath
                    projectName: (NSString *) aProjectName
                   fromTemplate: (NSString *) aTemplatePath
                          error: (NSError **) error;

- (NSDictionary *) getNewProjectSetupWithLocation: (BOOL) withLocation;

- (void) cancel: sender;
- (void) goToProjectLocationSelection: sender;
- (void) projectTypeSelected: sender;
- (void) doubleClickedProjectType: sender;

- (void) validateProjectName: sender;

// wizard panel delegate methods
- (NSView *) wizardPanel: (WKWizardPanel *) sender
            viewForStage: (NSString *) aStage;
- (NSView *)       wizardPanel: (WKWizardPanel *) sender
 initialFirstResponderForStage: (NSString *) aStage;

// outline view data source methods
- (int)     outlineView: (NSOutlineView *) outlineView
 numberOfChildrenOfItem: (id) item;
- (BOOL) outlineView: (NSOutlineView *) outlineView
    isItemExpandable: (id) item;
- (id) outlineView: (NSOutlineView *) outlineView
             child: (int) index
            ofItem: (id) item;
- (id)          outlineView: (NSOutlineView *) outlineView
  objectValueForTableColumn: (NSTableColumn *) tableColumn
                     byItem: (id) item;

@end

BOOL
CreateDirectoryAndIntermediateDirectories(NSString * dirPath,
                                          NSError ** error);

BOOL
ImportProjectFile(NSString * sourceFile,
                  NSString * destinationFile,
                  NSString * projectName,
                  NSError ** error);
