/*
    NewFileTypeChooser.h

    Interface declaration of the NewFileTypeChooser class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

/**
 * This object pops up a modal panel and asks the user to select
 * the file type of a new file to be created. The list of available
 * file types is taken from the Info-gnustep.plist's NSTypes array.
 */
@interface NewFileTypeChooser : NSObject
{
  id panel;
  id matrix;
  id okButton;

  NSArray * allTypes;
  NSArray * types;
}

+ shared;

/**
 * Runs the panel in a modal session and asks the user to select
 * a file type. The range of available types can be filtered with
 * the `key' and `value' arguments. If key = nil, the all file
 * types which have an NSName and NSHumanReadableName in NSTypes
 * are listed. If key != nil and value = nil then only those types
 * which have `key' defined in them to any value are listed. If
 * both key and value != nil, then only types which have `key'
 * set to `value' are listed.
 *
 * @return The NSName key's value in the selected type or `nil'
 * if the user pressed `Cancel'.
 */
- (NSString *) runModalWithRequiredKey: key value: value;

- (void) ok: sender;
- (void) cancel: sender;

@end
