/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ConstructorInvoker;
import org.fest.assertions.ToString;
import org.fest.util.Strings;

public final class ComparisonFailureFactory {
    private static final String EMPTY_MESSAGE = "";
    private static ConstructorInvoker constructorInvoker = new ConstructorInvoker();

    static void constructorInvoker(ConstructorInvoker newConstructorInvoker) {
        constructorInvoker = newConstructorInvoker;
    }

    public static AssertionError comparisonFailure(String message, Object expected, Object actual) {
        try {
            return ComparisonFailureFactory.newComparisonFailure(ComparisonFailureFactory.clean(message), expected, actual);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String clean(String message) {
        return message == null ? EMPTY_MESSAGE : message;
    }

    private static AssertionError newComparisonFailure(String message, Object expected, Object actual) throws Exception {
        String className = "org.junit.ComparisonFailure";
        Class[] parameterTypes = new Class[]{String.class, String.class, String.class};
        Object[] parameterValues = new Object[]{ComparisonFailureFactory.format(message), ComparisonFailureFactory.asString(expected), ComparisonFailureFactory.asString(actual)};
        Object o = constructorInvoker.newInstance(className, parameterTypes, parameterValues);
        if (o instanceof AssertionError) {
            return (AssertionError)o;
        }
        return null;
    }

    private static String asString(Object o) {
        if (o instanceof String) {
            return Strings.quote((String)((String)o));
        }
        if (o == null) {
            return null;
        }
        return ToString.toStringOf(o);
    }

    private static String format(String message) {
        if (Strings.isEmpty((String)message)) {
            return EMPTY_MESSAGE;
        }
        return Strings.concat((Object[])new Object[]{"[", message, "]"});
    }

    private ComparisonFailureFactory() {
    }
}

