/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayInspection {
    public static List<Object> copy(Object array) {
        int length = ArrayInspection.sizeOf(array);
        ArrayList<Object> copy = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            copy.add(Array.get(array, i));
        }
        return copy;
    }

    public static int sizeOf(Object array) {
        ArrayInspection.validateIsArray(array);
        return Array.getLength(array);
    }

    private static void validateIsArray(Object array) {
        if (array == null) {
            throw new NullPointerException("The array should not be null");
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("The given object is not an array");
        }
    }

    private ArrayInspection() {
    }
}

