/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSCache
extends ConcurrentHashMap<String, List<DNSEntry>> {
    private static Logger logger = LoggerFactory.getLogger((String)DNSCache.class.getName());
    private static final long serialVersionUID = 3024739453186759259L;

    public DNSCache() {
        this(1024);
    }

    public DNSCache(DNSCache map) {
        this(map != null ? map.size() : 1024);
        if (map != null) {
            this.putAll(map);
        }
    }

    public DNSCache(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new DNSCache(this);
    }

    public Collection<DNSEntry> allValues() {
        ArrayList<DNSEntry> allValues = new ArrayList<DNSEntry>();
        for (List entry : this.values()) {
            if (entry == null) continue;
            allValues.addAll(entry);
        }
        return allValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DNSEntry> getDNSEntryList(String name) {
        Collection<? extends DNSEntry> entryList = this._getDNSEntryList(name);
        if (entryList != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                entryList = new ArrayList<DNSEntry>(entryList);
            }
        } else {
            entryList = Collections.emptyList();
        }
        return entryList;
    }

    private Collection<? extends DNSEntry> _getDNSEntryList(String name) {
        return (Collection)this.get(name != null ? name.toLowerCase() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DNSEntry getDNSEntry(DNSEntry dnsEntry) {
        Collection<? extends DNSEntry> entryList;
        DNSEntry result = null;
        if (dnsEntry != null && (entryList = this._getDNSEntryList(dnsEntry.getKey())) != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                for (DNSEntry dNSEntry : entryList) {
                    if (!dNSEntry.isSameEntry(dnsEntry)) continue;
                    result = dNSEntry;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DNSEntry getDNSEntry(String name, DNSRecordType type, DNSRecordClass recordClass) {
        DNSEntry result = null;
        Collection<? extends DNSEntry> entryList = this._getDNSEntryList(name);
        if (entryList != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                for (DNSEntry dNSEntry : entryList) {
                    if (!dNSEntry.matchRecordType(type) || !dNSEntry.matchRecordClass(recordClass)) continue;
                    result = dNSEntry;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DNSEntry> getDNSEntryList(String name, DNSRecordType type, DNSRecordClass recordClass) {
        Collection<? extends DNSEntry> entryList = this._getDNSEntryList(name);
        if (entryList != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                entryList = new ArrayList<DNSEntry>(entryList);
                Iterator<? extends DNSEntry> i = entryList.iterator();
                while (i.hasNext()) {
                    DNSEntry testDNSEntry = i.next();
                    if (testDNSEntry.matchRecordType(type) && testDNSEntry.matchRecordClass(recordClass)) continue;
                    i.remove();
                }
            }
        } else {
            entryList = Collections.emptyList();
        }
        return entryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDNSEntry(DNSEntry dnsEntry) {
        boolean result = false;
        if (dnsEntry != null) {
            List entryList = (List)this.get(dnsEntry.getKey());
            if (entryList == null) {
                this.putIfAbsent(dnsEntry.getKey(), new ArrayList());
                entryList = (List)this.get(dnsEntry.getKey());
            }
            List list = entryList;
            synchronized (list) {
                entryList.add(dnsEntry);
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDNSEntry(DNSEntry dnsEntry) {
        List entryList;
        boolean result = false;
        if (dnsEntry != null && (entryList = (List)this.get(dnsEntry.getKey())) != null) {
            List list = entryList;
            synchronized (list) {
                entryList.remove(dnsEntry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceDNSEntry(DNSEntry newDNSEntry, DNSEntry existingDNSEntry) {
        boolean result = false;
        if (newDNSEntry != null && existingDNSEntry != null && newDNSEntry.getKey().equals(existingDNSEntry.getKey())) {
            List entryList = (List)this.get(newDNSEntry.getKey());
            if (entryList == null) {
                this.putIfAbsent(newDNSEntry.getKey(), new ArrayList());
                entryList = (List)this.get(newDNSEntry.getKey());
            }
            List list = entryList;
            synchronized (list) {
                entryList.remove(existingDNSEntry);
                entryList.add(newDNSEntry);
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder(2000);
        sb.append("\n\t---- cache ----");
        for (Map.Entry entry : this.entrySet()) {
            sb.append("\n\n\t\tname '").append((String)entry.getKey()).append('\'');
            List entryList = (List)entry.getValue();
            if (entryList != null && !entryList.isEmpty()) {
                List list = entryList;
                synchronized (list) {
                    for (DNSEntry dnsEntry : entryList) {
                        sb.append("\n\t\t\t").append(dnsEntry.toString());
                    }
                    continue;
                }
            }
            sb.append(" : no entries");
        }
        return sb.toString();
    }

    public void logCachedContent() {
        if (!logger.isTraceEnabled()) {
            return;
        }
        logger.trace("Cached DNSEntries: {}", (Object)this.toString());
    }
}

