/*

B.cmd 1.20
----------


What version of OS/2 is this for?
---------------------------------
This script will run on ANY OS/2 system. However, it is intended for Warp 3.0
Blue Spine. The reason for the Blue Spine requirement is that there are updates
made to winos2 that MAY or MAY NOT work correctly on the Red Spine distribution
and REAL windows 3.1.


Now, if you have a Warp 3.0 Red Spine installation and you DON'T use WinOS2,
then you can go ahead and use this without problems...


What it does:
-------------
This rexx script patches the OS/2 system files syslevel.os2 and syslevel.mpm to
allow the application of FixPaks greater than #40. These two files are located
at: \OS2\INSTALL\SYSLEVEL.OS2 and \MMOS2\INSTALL\SYSLEVEL.MPM. These are the
ONLY two files that this script touches and before it does, backups of the
originals are made to: \OS2\INSTALL\SYSLEVEL.OS2.BACKUP and
\MMOS2\INSTALL\SYSLEVEL.MPM.BACKUP


How it does it:
---------------
By patching these two files, the CSF installer is fooled into thinking that the
target system is a LanServer 4.0 installation.


Should I use this rexx script?
------------------------------
Use TOTALLY on your on decision. I don't support this is ANY WAY, SHAPE or
MANNER than a very big, smiley... GOOD LUCK, BUB!


How often do I need to run this thing...
----------------------------------------
Only once! Just before applying any of the fixpaks greater than #40. For the
totally stupid... this means fixpak #41 or higher...


How do I do it?
---------------
Run this script from the command line, with the argument "COOL", on your OS/2
BOOT hard drive. If no errors pop up, then it worked!

The actual command looks like: B cool

*/

  '@echo off'

  parse arg stuff .

  stuff=translate(stuff)

  if stuff \= 'COOL' then do
    say'Before you can actually run his script, you MUST read the comments inside'
    say'of it.'
    exit 1
    end /* if */

  os2dir='\os2\install\'
  os2="SYSLEVEL                      %    0  XR03005_XR03005_IBM OS/2 Base Operating System                                                  562274700 0S             "
  mpmdir='\mmos2\install\'
  mpm="SYSLEVEL                      %    0  XR03005_XR03005_IBM Multimedia Presentation Manager/2                                           562274700 0S             "

/* fix os2 */

  filename='syslevel.os2'

  if stream(os2dir||filename,'c','query exists')='' then do
    say''
    say'Can not find '||filename||', patch not applied!'
    say''
    exit 1
    end /* if */

  say'Found '||filename

/* if it's never been done, make a backup of the original file */

  if stream(os2dir||filename'.backup','c','query exists') ='' then do
    'copy '||os2dir||filename||' '||os2dir||filename||'.backup 1>nul'
    say'Made backup of original '||filename||' to '||filename||'.back.'
    end /* if */

/* make the file accessable */

  'attrib -r '||os2dir||filename||' 1>nul'
  say'Removed read restriction from '||filename

/* use charout instead of lineout... we don't want CRLF's in these files! */

  call charout os2dir||filename, os2, 1
  call stream  os2dir||filename,'c','close'
  say'Applied patch to '||filename

/* fix mpm */

  filename='syslevel.mpm'

  if stream(mpmdir||filename,'c','query exists') ='' then do
    say''
    say'Can not find '||filename||', patch not applied!'
    say''
    exit 1
    end /* if */

  say''
  say'Found '||filename

/* if it's never been done, make a backup of the original file */

  if stream(mpmdir||filename||'.backup','c','query exists') ='' then do
    'copy '||mpmdir||filename||' '||mpmdir||filename||'.backup 1>nul'
    say'Made backup of original '||filename||' to '||filename||'.back.'
    end /* if */

/* make the file accessable */

  'attrib -r '||mpmdir||filename||' 1>nul'
  say'Removed read restriction from '||filename

/* use charout instead of lineout... we don't want CRLF's in these files! */

  call charout mpmdir||filename, mpm, 1
  call stream  mpmdir||filename,'c','close'
  say'Applied patch to '||filename
  say''

  say'All done and ready to apply fixpaks greater than #40'
  say''
