/* rexx */

parse UPPER arg fHandle bootdrive  PATH COMPONENT

/* translation strings: */
message1R = "La versin de Java Runtime del sistema es ms reciente que la que se est instalando. Desea proseguir con la instalacin de Java Runtime?"
message2R = "Est a punto de efectuar la instalacin sobre un nivel Beta o Alpha de Java Runtime antiguo. Desea proseguir con la instalacin de Java Runtime?"
message1S = "La versin de Ejemplos del sistema es ms reciente que la que se est instalando. Desea proseguir con la instalacin del componente Ejemplos?"
message2S = "Est a punto de efectuar la instalacin sobre un nivel Beta o Alpha de Ejemplos antiguo. Desea proseguir con la instalacin del componente Ejemplos?"
message1T = "La versin del Kit de utilidades (JDK) del sistema es ms reciente que la que se est instalando. Desea proseguir con la instalacin del componente Kit de utilidades?"
message2T = "Est a punto de efectuar la instalacin sobre un nivel Beta o Alpha del Kit de utilidades (JDK) antiguo. Desea proseguir con la instalacin del componente Kit de utilidades?"
message1D = "La versin de ICATJAVA para OS/2 del sistema es ms reciente que la que se est instalando. Desea proseguir con la instalacin del componente ICATJAVA?"
message2D = "Est a punto de efectuar la instalacin sobre un nivel Beta o Alpha del ICATJAVA para OS/2 antiguo. Desea proseguir con la instalacin del componente ICATJAVA?"
message1SR = "La versin de Runtime de Swing del sistema es ms reciente que la que se est instalando. Desea proseguir con la instalacin del componente Runtime de Swing?"
message2SR = "Est a punto de efectuar la instalacin sobre un nivel Beta o Alpha de Runtime de Swing antiguo. Desea proseguir con la instalacin del componente Runtime de Swing?"
message1ST = "La versin del Kit de utilidades de Swing del sistema es ms reciente que la que se est instalando. Desea proseguir con la instalacin del componente Kit de utilidades de Swing?"
message2ST = "Est a punto de efectuar la instalacin sobre un nivel Beta o Alpha del Kit de utilidades de Swing antiguo. Desea proseguir con la instalacin del componente Kit de utilidades de Swing?"
message1RM = "La versin del Kit de utilidades de RMI-IIOP del sistema es ms reciente que la que se est instalando. Desea proseguir con la instalacin del componente Kit de utilidades de RMI-IIOP?"
message2RM = "Est a punto de efectuar la instalacin sobre un nivel Beta o Alpha del Kit de utilidades de RMI-IIOP antiguo. Desea proseguir con la instalacin del componente Kit de utilidades de RMI-IIOP?"

call RxFuncAdd 'RexxInstResolveVariables', 'WPINSTAL', 'RexxInstResolveVariables'
call RxFuncAdd 'RexxInstSetVariable', 'WPINSTAL', 'RexxInstSetVariable'
call RxFuncAdd 'RexxInstDeselect', 'WPINSTAL', 'RexxInstDeselect'

continue = RexxInstResolveVariables( fHandle, "{Continue}", 1)
if continue = "UNATTENDED" then EXIT

if ReadSysLevel(PATH"\syslevel."COMPONENT) then do
      if substr(st.achCsdLevel, 4, 4) = 9999 then CALL 9999;
      else if substr(st.achCsdLevel, 4, 4)>> 4008 then CALL LOWER
      exit /* current syslevel at equal or higher level */
      end
EXIT   /*  none found  */


9999:   /* ALPHA/BETA level exists:    */
        path = RexxInstResolveVariables( fHandle, "{UserExitPath}", 1)
         if (COMPONENT == "JAV") then
             path'\..\message' bootdrive fHandle message2R
         else
         if (COMPONENT == "JSP") then
             path'\..\message' bootdrive fHandle message2S
         else
         if (COMPONENT == "JTK") then
             path'\..\message' bootdrive fHandle message2T
         else
         if (COMPONENT == "ICA") then
             path'\..\message' bootdrive fHandle message2D
         else
         if (COMPONENT == "SWR") then
             path'\..\message' bootdrive fHandle message2SR
         else
         if (COMPONENT == "SWT") then
             path'\..\message' bootdrive fHandle message2ST
         else
         if (COMPONENT == "RMI") then
             path'\..\message' bootdrive fHandle message2RM
         continue = RexxInstResolveVariables( fHandle, "{Continue}", 1)
         if continue = "QUIT" then CALL STOP; else EXIT


LOWER:   /* installing version lower than current version  */
        path = RexxInstResolveVariables( fHandle, "{UserExitPath}", 1)
         if (COMPONENT == "JAV") then
             path'\..\message' bootdrive fHandle message1R
         else
         if (COMPONENT == "JSP") then
             path'\..\message' bootdrive fHandle message1S
         else
         if (COMPONENT == "JTK") then
             path'\..\message' bootdrive fHandle message1T
         else
         if (COMPONENT == "ICA") then
             path'\..\message' bootdrive fHandle message1D
         else
         if (COMPONENT == "SWR") then
             path'\..\message' bootdrive fHandle message1SR
         else
         if (COMPONENT == "SWT") then
             path'\..\message' bootdrive fHandle message1ST
         else
         if (COMPONENT == "RMI") then
             path'\..\message' bootdrive fHandle message1RM
        continue = RexxInstResolveVariables( fHandle, "{Continue}", 1)
         if continue = "QUIT" then CALL STOP; else EXIT



STOP:
         if (COMPONENT == "JAV") then
         DO
             rc = RexxInstDeselect( fHandle, Runtime);
             keepJAVA11U = RexxInstResolveVariables( fHandle, "{Java11:TlktDocSelected}", 1)
             if ( keepJAVA11U == "NO" )
             then
             rc = RexxInstDeselect( fHandle, Java11U );
         END;
         else
         if (COMPONENT == "JSP") then
             rc = RexxInstDeselect( fHandle, Samples);
         else
         if (COMPONENT == "JTK") then
             rc = RexxInstDeselect( fHandle, Toolkit);
         else
         if (COMPONENT == "ICA") then
             rc = RexxInstDeselect( fHandle, Debugger);
         else
         if (COMPONENT == "SWR") then
             rc = RexxInstDeselect( fHandle, SwingRuntime);
         else
         if (COMPONENT == "SWT") then
             rc = RexxInstDeselect( fHandle, SwingToolkit);
         else
         if (COMPONENT == "RMI") then
             rc = RexxInstDeselect( fHandle, RMIIIOPToolkit);
EXIT


ReadSysLevel: procedure expose slfh. st.
call Trace OFF
parse arg fs

   res = 0
   if stream(fs,"C","Query Exists") <> "" then do
      data = charin(fs,1,chars(fs))
      slfh.usSignature   = c2x(reverse(substr(data,1,2)))     /* special # for id of syslevel file */
      slfh.achSignature  = substr(data,3,8)                   /* string to id slf file, must be 'SYSLEVEL' */
      slfh.achJulian     = substr(data,11,5)                  /* date of version */
      slfh.usSlfVersion  = c2x(reverse(substr(data,16,2)))    /* version of syslevel file, must be 1 */
      slfh.ausReserved   = c2x(substr(data,18,16))            /* reserved */
      slfh.ulTableOffset = c2d(reverse(substr(data,34,4)))    /* offset of SYSTABLE */

      /* Calculate table start
      */
      tblst = slfh.ulTableOffset+1

      st.usSysId       = c2x(reverse(substr(data, tblst+0,2))) /* identifies system /subsytem */
      st.bSysEdition   = c2x(substr(data, tblst+2,1))          /* edition of system, eg SE=00, EE=01 */
      st.bSysVersion   = c2x(substr(data, tblst+3,1))          /* version, eg 1.00=10, 1.10=11 */
      st.bSysModify    = c2x(substr(data, tblst+4,1))          /* modify, eg 1.00=00, 1.01=01 */
      st.usSysDate     = c2x(reverse(substr(data, tblst+5,2))) /* date of system */
      st.achCsdLevel   = substr(data, tblst+7,8)               /* subsytem CSD level, eg, XR?0000_ */
      st.achCsdPrev    = substr(data, tblst+15,8)              /* as above, except for prev system */
      st.achSysName    = substr(data, tblst+23,80)             /* Title of system / subsytem (ASCIIZ) */
      st.achCompId     = substr(data, tblst+103,9)             /* component ID of subsytem */
      st.bRefreshLevel = c2x(substr(data, tblst+112,1))
      st.achType       = substr(data, tblst+113,9)             /* Null terminated type (8 chars +'\0') */
      st.usReserved    = substr(data, tblst+122,12)            /* reserved, must be 0 */
      res = 1
      call stream fs,"C","Close"
   end
return res

