/* check prereqs                                                        */
parse arg hFeature bootdrive where
file = bootdrive'\kmcrpc10'

/*  These three messages are the only translatable items in the file:              */
message1="El font Unicode no est presente en el paquete de instalacin. Consulte el archivo Readme para obtener informacin sobre cmo bajar el paquete de fonts."
message2="Este sistema no est en el nivel de Paquete de Arreglo correcto para utilizar el font Unicode. El font Unicode no se instalar. Consulte el archivo Readme para obtener ms informacin acerca de los prerrequisitos del Paquete de Arreglo."
message3="La versin de OS/2 de su sistema no cumple los prerrequisitos para la instalacin de Java; la instalacin se cancelar. Consulte el archivo Readme para obtener ms detalles."



call RxFuncAdd 'RexxInstDeselect', 'WPINSTAL', 'RexxInstDeselect'
call RxFuncAdd 'RexxInstResolveVariables', 'WPINSTAL', 'RexxInstResolveVariables'
call RxFuncAdd 'RexxInstSetVariable', 'WPINSTAL', 'RexxInstSetVariable'


continue = RexxInstResolveVariables( hFeature, "{Continue}", 1)
path = RexxInstResolveVariables( hFeature, "{UserExitPath}", 1)
say path
if (where == PREREQ) then CALL PREREQ

/* check for font in install package */
path = RexxInstResolveVariables( hFeature, "{UserExitPath}", 1)
font = path"\..\package\tnrmt30.ttf"
rc = stream( font, 'c', 'open read')
empty = LINES( font )
rc = stream( font, 'c', 'close' )
if (empty == "0" ) then
        DO
        rc = RexxInstDeselect( hFeature, "" )
        if continue <> "UNATTENDED" then
        DO
          keep = RexxInstResolveVariables( hFeature, "{Java11:MB_VAR}", 1)
          zero = 0
          rc = RexxInstSetVariable( hFeature,"Java11", "MB_VAR", zero );
          new = RexxInstResolveVariables( hFeature, "{Java11:MB_VAR}", 1)
          path'\..\message ' bootdrive hFeature message1
          rc = RexxInstSetVariable( hFeature, "Java11", "MB_VAR", 4 );
        END
        EXIT
        END



PREREQ:

/* check for FixPack 30 or higher    */

tmpfile = bootdrive'\j11servc.tmp'
'bldlevel 'bootdrive'\os2krnl >'  tmpfile
line = LINEIN( tmpfile)
ret = STREAM( tmpfile, 'c', 'close')
'@erase' tmpfile

'bldlevel 'bootdrive'\os2krnl >'  file
line = LINEIN( file)
say line
PARSE VAR line temp '#@';
temp = REVERSE( temp)
PARSE VAR temp temp ':MBI';
level = REVERSE( temp)

if (where == PREREQ) then CALL CHECKBASE

if level < 8.254
then
DO
rc = RexxInstDeselect( hFeature, "" )
if continue <> "UNATTENDED" then
DO
  keep = RexxInstResolveVariables( hFeature, "{MB_VAR}", 1)
  rc = RexxInstSetVariable( hFeature, "Java11", "MB_VAR", 0 );
  path'\..\message ' bootdrive hFeature message2
  rc = RexxInstSetVariable( hFeature, "Java11", "MB_VAR", keep );
END
END

ret = STREAM( file, 'c', 'close')
'@erase' file
EXIT

CHECKBASE:
if level < 9.23 then x = RexxInstSetVariable( hFeature, "Java11", "MERLIN", "NO")
if level < 8.162
then
DO
if level = 7.029 then CALL BYE
if continue <> "UNATTENDED" then
DO
  rc = RexxInstSetVariable( hFeature, "Java11", "MB_VAR", 0 );
  path'\..\message ' bootdrive hFeature message3
END
rc = RexxInstDeselect( hFeature, "Java11" )
END


BYE:
ret = STREAM( file, 'c', 'close')
'@erase' file
EXIT


