/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.util;

import com.sun.rmi.io.IIOPInputStream;
import com.sun.rmi.io.IIOPOutputStream;
import com.sun.rmi.io.LibraryManager;
import com.sun.rmi.util.JDKBridgeDelegate;
import com.sun.rmi.util.JDKClassLoader;
import com.sun.rmi.util.Utility;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.util.Hashtable;
import java.util.Properties;

public class JDKBridge {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1998, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final String LOCAL_CODEBASE_KEY = "java.rmi.server.codebase";
    private static final String USE_CODEBASE_ONLY_KEY = "java.rmi.server.useCodebaseOnly";
    private static final String DELEGATE_11 = "com.sun.rmi.util.JDKBridgeDelegate11";
    private static final String DELEGATE_12 = "com.sun.rmi.util.JDKBridgeDelegate12";
    private static String localCodebase = null;
    private static boolean useCodebaseOnly;
    private static final boolean isJDK12;
    private static final JDKBridgeDelegate delegate;
    private static boolean libraryLoaded;
    private static Properties orbProperties;
    private static boolean setORBProperties;
    private static boolean pre118;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static boolean is12VM() {
        return isJDK12;
    }

    public static boolean isPre12VM() {
        return !isJDK12;
    }

    public static String getCodebase(Class clazz) {
        return delegate.getCodebase(clazz, localCodebase);
    }

    public static String getLocalCodebase() {
        return localCodebase;
    }

    public static boolean useCodebaseOnly() {
        return useCodebaseOnly;
    }

    public static String getSystemProperty(String string) {
        return delegate.getSystemProperty(string);
    }

    public static Class loadClass(String string, String string2, Class clazz) throws ClassNotFoundException {
        ClassLoader classLoader = null;
        if (clazz != null) {
            classLoader = clazz.getClassLoader();
        }
        if (!libraryLoaded) {
            LibraryManager.load();
            libraryLoaded = true;
        }
        if (classLoader == null) {
            return delegate.loadClass(string, string2, useCodebaseOnly);
        }
        try {
            return delegate.loadClass(string, string2, useCodebaseOnly);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return classLoader.loadClass(string);
        }
    }

    public static Class loadClass(String string, String string2) throws ClassNotFoundException {
        return JDKBridge.loadClass(string, string2, null);
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        return JDKBridge.loadClass(string, null, null);
    }

    public static void loadLibrary(String string) {
        delegate.loadLibrary(string);
    }

    public static Properties getORBPropertiesFile() {
        if (!setORBProperties) {
            orbProperties = delegate.getORBPropertiesFile();
            setORBProperties = true;
        }
        return orbProperties;
    }

    public static Field getDeclaredField(Class clazz, String string) throws NoSuchFieldException {
        return delegate.getDeclaredField(clazz, string);
    }

    public static Field[] getDeclaredFields(Class clazz) {
        return delegate.getDeclaredFields(clazz);
    }

    public static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        return delegate.getDeclaredMethod(clazz, string, classArray);
    }

    public static Method[] getDeclaredMethods(Class clazz) {
        return delegate.getDeclaredMethods(clazz);
    }

    public static Constructor[] getDeclaredConstructors(Class clazz) {
        return delegate.getDeclaredConstructors(clazz);
    }

    public static Remote getJRMPStub(Remote remote) throws NoSuchObjectException {
        return delegate.getJRMPStub(remote);
    }

    public static void unexportJRMP(Remote remote) throws NoSuchObjectException {
        delegate.unexportJRMP(remote);
    }

    public static Hashtable getPersistentFields(Class clazz) {
        return delegate.getPersistentFields(clazz);
    }

    public static final void main(String[] stringArray) {
        if (JDKBridge.is12VM()) {
            System.out.println("1.2 VM");
            return;
        }
        System.out.println("1.1 VM");
    }

    public static synchronized void setCodebaseProperties() {
        String string = JDKBridge.getSystemProperty(LOCAL_CODEBASE_KEY);
        if (string != null && string.trim().length() > 0) {
            localCodebase = string;
        }
        if ((string = JDKBridge.getSystemProperty(USE_CODEBASE_ONLY_KEY)) != null && string.trim().length() > 0) {
            useCodebaseOnly = Boolean.valueOf(string);
        }
    }

    public static Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (bl) {
            return JDKClassLoader.loadClass(null, string, isJDK12);
        }
        return Class.forName(string);
    }

    public static synchronized void setLocalCodebase(String string) {
        localCodebase = string;
    }

    private static boolean is12() {
        try {
            Class<?> clazz = Class.forName("java.security.PrivilegedAction");
            Class<?> clazz2 = Class.forName("java.security.AccessController");
            Class<?> clazz3 = Class.forName("java.lang.Class");
            Class[] classArray = new Class[]{clazz};
            clazz2.getMethod("doPrivileged", classArray);
            Class[] classArray2 = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = JDKBridge.class$("java.lang.String")), Boolean.TYPE, class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = JDKBridge.class$("java.lang.ClassLoader"))};
            clazz3.getMethod("forName", classArray2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static JDKBridgeDelegate loadDelegate() {
        String string = isJDK12 ? DELEGATE_12 : DELEGATE_11;
        try {
            Class<?> clazz = Class.forName(string);
            return (JDKBridgeDelegate)clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new Error("JDKBridge: failed to load " + string);
        }
    }

    public static boolean isPre118() {
        return pre118;
    }

    public static IIOPOutputStream createOutputStream() {
        IIOPOutputStream iIOPOutputStream = (IIOPOutputStream)delegate.createOutputStream();
        iIOPOutputStream.useOldNativeInterface = JDKBridge.needsNMI();
        return iIOPOutputStream;
    }

    public static IIOPInputStream createInputStream() {
        IIOPInputStream iIOPInputStream = (IIOPInputStream)delegate.createInputStream();
        iIOPInputStream.useOldNativeInterface = JDKBridge.needsNMI();
        return iIOPInputStream;
    }

    public static boolean needsNMI() {
        int n;
        int n2;
        String string;
        String string2;
        if (!pre118) {
            return false;
        }
        String string3 = System.getProperty("awt.toolkit", "NONE");
        String string4 = System.getProperty("java.vendor");
        if (string3.equals("com.ibm.uvm.awt.UvmToolkit") && string4.equals("IBM")) {
            return false;
        }
        String string5 = System.getProperty("os.name");
        String string6 = System.getProperty("java.version");
        if (string4.equals("IBM Corporation") && string5.equals("AIX") && string6.equals("1.1.6")) {
            try {
                string2 = System.getProperty("java.fullversion", "NONE");
                string = "a116-";
                n2 = string2.indexOf(string) + string.length();
                n = string2.indexOf(32, n2);
                if (Integer.parseInt(string2.substring(n2, n)) >= 19990331) {
                    return false;
                }
            }
            catch (Exception exception) {
                return true;
            }
        }
        if (string4.equals("IBM Corporation") && string5.equals("Windows NT") && string6.equals("1.1.7")) {
            try {
                string2 = System.getProperty("java.fullversion", "NONE");
                string = "n117p-";
                n2 = string2.indexOf(string) + string.length();
                n = string2.indexOf(32, n2);
                if (Integer.parseInt(string2.substring(n2, n)) >= 19990416) {
                    return false;
                }
            }
            catch (Exception exception) {
                return true;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        isJDK12 = JDKBridge.is12();
        delegate = JDKBridge.loadDelegate();
        orbProperties = null;
        JDKBridge.setCodebaseProperties();
        pre118 = Utility.compareVersion(System.getProperty("java.version"), "1.1.8") < 0;
    }
}

