/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameImpl;

public class CompoundName
implements Name {
    protected transient NameImpl impl;
    protected transient Properties mySyntax;

    public CompoundName(String string, Properties properties) throws InvalidNameException {
        this.mySyntax = properties;
        this.impl = new NameImpl(properties, string);
    }

    protected CompoundName(Enumeration enumeration, Properties properties) {
        this.mySyntax = properties;
        this.impl = new NameImpl(properties, enumeration);
    }

    public Name add(int n, String string) throws InvalidNameException {
        this.impl.add(n, string);
        return this;
    }

    public Name add(String string) throws InvalidNameException {
        this.impl.add(string);
        return this;
    }

    public Name addAll(int n, Name name) throws InvalidNameException {
        if (name instanceof CompoundName) {
            this.impl.addAll(n, name.getAll());
            return this;
        }
        throw new InvalidNameException("Not a compound name: " + name.toString());
    }

    public Name addAll(Name name) throws InvalidNameException {
        if (name instanceof CompoundName) {
            this.impl.addAll(name.getAll());
            return this;
        }
        throw new InvalidNameException("Not a compound name: " + name.toString());
    }

    public Object clone() {
        return new CompoundName(this.getAll(), this.mySyntax);
    }

    public int compareTo(Object object) {
        if (!(object instanceof CompoundName)) {
            throw new ClassCastException("Not a CompoundName");
        }
        return this.impl.compareTo(((CompoundName)object).impl);
    }

    public boolean endsWith(Name name) {
        if (name instanceof CompoundName) {
            return this.impl.endsWith(name.size(), name.getAll());
        }
        return false;
    }

    public boolean equals(Object object) {
        return object != null && object instanceof CompoundName && this.impl.equals(((CompoundName)object).impl);
    }

    public String get(int n) {
        return this.impl.get(n);
    }

    public Enumeration getAll() {
        return this.impl.getAll();
    }

    public Name getPrefix(int n) {
        Enumeration enumeration = this.impl.getPrefix(n);
        return new CompoundName(enumeration, this.mySyntax);
    }

    public Name getSuffix(int n) {
        Enumeration enumeration = this.impl.getSuffix(n);
        return new CompoundName(enumeration, this.mySyntax);
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mySyntax = (Properties)objectInputStream.readObject();
        this.impl = new NameImpl(this.mySyntax);
        int n = objectInputStream.readInt();
        try {
            while (--n >= 0) {
                this.add((String)objectInputStream.readObject());
            }
        }
        catch (InvalidNameException invalidNameException) {
            throw new StreamCorruptedException("Invalid name");
        }
    }

    public Object remove(int n) throws InvalidNameException {
        return this.impl.remove(n);
    }

    public int size() {
        return this.impl.size();
    }

    public boolean startsWith(Name name) {
        if (name instanceof CompoundName) {
            return this.impl.startsWith(name.size(), name.getAll());
        }
        return false;
    }

    public String toString() {
        return this.impl.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.mySyntax);
        objectOutputStream.writeInt(this.size());
        Enumeration enumeration = this.getAll();
        while (enumeration.hasMoreElements()) {
            objectOutputStream.writeObject(enumeration.nextElement());
        }
    }
}

