/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.tools;

import com.ibm.security12.java.security.KeyStore;
import com.ibm.security12.java.security.KeyStoreException;
import com.ibm.security12.java.security.Permission;
import com.ibm.security12.java.security.UnrecoverableKeyException;
import com.ibm.security12.java.security.cert.Certificate;
import com.ibm.security12.java.security.cert.CertificateException;
import com.ibm.security12.sun.security.provider.PolicyParser;
import com.ibm.security12.sun.security.tools.PolicyEntry;
import com.ibm.security12.sun.security.tools.ToolWindow;
import com.ibm.security12.sun.security.util.PropertyExpander;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Enumeration;
import java.util.Vector;

class PolicyTool {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    Vector warnings;
    boolean newWarning = false;
    boolean modified = false;
    private static final boolean testing = false;
    private static final Class[] PARAMS = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PolicyTool.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PolicyTool.class$("java.lang.String"))};
    private static String policyFileName = null;
    private Vector policyEntries = new Vector();
    private PolicyParser parser = new PolicyParser();
    private KeyStore keyStore;
    private String keyStoreName = " ";
    private String keyStoreType = " ";
    static /* synthetic */ Class class$java$lang$String;

    private PolicyTool() {
        this.warnings = new Vector();
    }

    String getPolicyFileName() {
        return policyFileName;
    }

    void setPolicyFileName(String string) {
        policyFileName = string;
    }

    void setKeyStoreInfo(String string, String string2) {
        this.keyStoreName = string;
        this.keyStoreType = string2;
        this.modified = true;
    }

    String getKeyStoreName() {
        return this.keyStoreName;
    }

    String getKeyStoreType() {
        return this.keyStoreType;
    }

    void openPolicy(String string) throws MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, PolicyParser.ParsingException, IOException, FileNotFoundException, CertificateException, Exception {
        this.newWarning = false;
        this.policyEntries = new Vector();
        this.parser = new PolicyParser();
        this.warnings = new Vector();
        this.setPolicyFileName(null);
        this.setKeyStoreInfo(null, null);
        if (string == null) {
            this.modified = false;
            return;
        }
        this.setPolicyFileName(string);
        this.parser.read(new FileReader(string));
        this.setKeyStoreInfo(this.parser.getKeyStoreUrl(), this.parser.getKeyStoreType());
        Enumeration enumeration = this.parser.grantElements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String[] stringArray2;
            PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
            if (grantEntry.signedBy != null) {
                stringArray2 = this.parseSigners(grantEntry.signedBy);
                int n = 0;
                while (n < stringArray2.length) {
                    stringArray = this.getPublicKeyAlias(stringArray2[n]);
                    if (stringArray == null) {
                        this.newWarning = true;
                        this.warnings.addElement("Warning: A public key for alias '" + stringArray2[n] + "' does not exist.");
                    }
                    ++n;
                }
            }
            stringArray2 = grantEntry.permissionElements();
            while (stringArray2.hasMoreElements()) {
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)stringArray2.nextElement();
                try {
                    this.verifyPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.newWarning = true;
                    this.warnings.addElement("Warning: Class not found: " + permissionEntry.permission + ".");
                }
                if (permissionEntry.signedBy == null) continue;
                stringArray = this.parseSigners(permissionEntry.signedBy);
                int n = 0;
                while (n < stringArray.length) {
                    PublicKey publicKey = this.getPublicKeyAlias(stringArray[n]);
                    if (publicKey == null) {
                        this.newWarning = true;
                        this.warnings.addElement("Warning: A public key for alias '" + stringArray[n] + "' does not exist.");
                    }
                    ++n;
                }
            }
            PolicyEntry policyEntry = new PolicyEntry(this, grantEntry);
            this.policyEntries.addElement(policyEntry);
        }
        if (!this.newWarning) {
            this.warnings.addElement("Policy File opened successfully");
        }
        this.modified = false;
    }

    void savePolicy(String string) throws FileNotFoundException, IOException {
        this.parser.setKeyStoreUrl(this.keyStoreName);
        this.parser.setKeyStoreType(this.keyStoreType);
        this.parser.write(new FileWriter(string));
        this.modified = false;
    }

    void openKeyStore(String string, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException, PropertyExpander.ExpandException {
        Object object;
        if (string == null || string.length() == 0) {
            throw new IOException("null Keystore name");
        }
        string = PropertyExpander.expand(string).replace(File.separatorChar, '/');
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            object = new File(policyFileName);
            URL uRL2 = new URL("file:" + ((File)object).getCanonicalPath());
            uRL = new URL(uRL2, string);
        }
        object = uRL.openStream();
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load((InputStream)object, cArray);
        ((InputStream)object).close();
    }

    boolean addEntry(PolicyEntry policyEntry, int n) {
        if (n < 0) {
            this.policyEntries.addElement(policyEntry);
            this.parser.add(policyEntry.getGrantEntry());
        } else {
            PolicyEntry policyEntry2 = (PolicyEntry)this.policyEntries.elementAt(n);
            this.parser.replace(policyEntry2.getGrantEntry(), policyEntry.getGrantEntry());
            this.policyEntries.setElementAt(policyEntry, n);
        }
        return true;
    }

    boolean addPermEntry(PolicyEntry policyEntry, PolicyParser.PermissionEntry permissionEntry, int n) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        if (grantEntry.contains(permissionEntry)) {
            return false;
        }
        Vector vector = grantEntry.permissionEntries;
        if (n != -1) {
            vector.setElementAt(permissionEntry, n);
        } else {
            vector.addElement(permissionEntry);
        }
        this.modified = true;
        return true;
    }

    boolean removePermEntry(PolicyEntry policyEntry, PolicyParser.PermissionEntry permissionEntry) {
        PolicyParser.GrantEntry grantEntry = policyEntry.getGrantEntry();
        this.modified = grantEntry.remove(permissionEntry);
        return this.modified;
    }

    boolean removeEntry(PolicyEntry policyEntry) {
        this.parser.remove(policyEntry.getGrantEntry());
        this.modified = true;
        return this.policyEntries.removeElement(policyEntry);
    }

    PolicyEntry[] getEntry() {
        if (this.policyEntries.size() > 0) {
            PolicyEntry[] policyEntryArray = new PolicyEntry[this.policyEntries.size()];
            int n = 0;
            while (n < this.policyEntries.size()) {
                policyEntryArray[n] = (PolicyEntry)this.policyEntries.elementAt(n);
                ++n;
            }
            return policyEntryArray;
        }
        return null;
    }

    PublicKey getPublicKeyAlias(String string) throws CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, PropertyExpander.ExpandException {
        try {
            this.openKeyStore(this.keyStoreName, null);
            Certificate certificate = this.keyStore.getCertificate(string);
            if (certificate == null) {
                return null;
            }
            PublicKey publicKey = certificate.getPublicKey();
            return publicKey;
        }
        catch (IOException iOException) {
            this.newWarning = true;
            this.warnings.addElement("Warning: Unable to open Keystore: " + this.keyStoreName);
            return null;
        }
    }

    String[] getPublicKeyAlias() throws CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, PropertyExpander.ExpandException {
        try {
            int n = 0;
            String[] stringArray = null;
            this.openKeyStore(this.keyStoreName, null);
            Enumeration enumeration = this.keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                enumeration.nextElement();
                ++n;
            }
            if (n > 0) {
                stringArray = new String[n];
                n = 0;
                enumeration = this.keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    stringArray[n] = new String((String)enumeration.nextElement());
                    ++n;
                }
            }
            return stringArray;
        }
        catch (IOException iOException) {
            this.newWarning = true;
            this.warnings.addElement("Warning: Unable to open Keystore: " + this.keyStoreName);
            return null;
        }
    }

    String[] parseSigners(String string) {
        String[] stringArray = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 >= 0) {
            n3 = string.indexOf(44, n2);
            if (n3 < 0) continue;
            ++n;
            n2 = n3 + 1;
        }
        stringArray = new String[n];
        n3 = 0;
        n2 = 0;
        while (n3 >= 0) {
            n3 = string.indexOf(44, n2);
            if (n3 >= 0) {
                stringArray[n4] = string.substring(n2, n3).trim();
                ++n4;
                n2 = n3 + 1;
                continue;
            }
            stringArray[n4] = string.substring(n2).trim();
        }
        return stringArray;
    }

    void verifyPermission(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        Constructor<?> constructor = clazz.getConstructor(PARAMS);
        Permission cfr_ignored_0 = (Permission)constructor.newInstance(string2, string3);
    }

    static void parseArgs(String[] stringArray) {
        int n = 0;
        n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n];
            if (string.equals("-file")) {
                if (++n == stringArray.length) {
                    PolicyTool.usage();
                }
                policyFileName = stringArray[n];
            } else {
                System.err.println("Illegal option: " + string);
                PolicyTool.usage();
            }
            ++n;
        }
    }

    static void usage() {
        System.out.println("Usage: policytool [options]");
        System.out.println();
        System.out.println("  [-file <file>]    policy file location");
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        PolicyTool.parseArgs(stringArray);
        ToolWindow toolWindow = new ToolWindow(new PolicyTool());
        toolWindow.displayToolWindow(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

