/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security.cert;

import com.ibm.security12.java.security.cert.CRLException;
import com.ibm.security12.java.security.cert.X509Extension;
import com.ibm.security12.java.util.Set;
import java.math.BigInteger;
import java.util.Date;

public abstract class X509CRLEntry
implements X509Extension {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRLEntry)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((X509CRLEntry)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] != byArray2[n]) {
                    return false;
                }
                ++n;
            }
        }
        catch (CRLException cRLException) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            int n2 = 1;
            while (n2 < byArray.length) {
                n += byArray[n2] * n2;
                ++n2;
            }
        }
        catch (CRLException cRLException) {
            return n;
        }
        return n;
    }

    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public abstract String toString();

    public abstract boolean hasUnsupportedCriticalExtension();

    public abstract Set getCriticalExtensionOIDs();

    public abstract Set getNonCriticalExtensionOIDs();

    public abstract byte[] getExtensionValue(String var1);
}

