/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AVA;
import java.io.IOException;

class RDN {
    protected AVA[] assertion;

    RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new IOException("X500 RDN");
        }
        int n = 1;
        this.assertion = new AVA[n];
        int n2 = 0;
        while (n2 < n) {
            this.assertion[n2] = new AVA(derValue.data);
            ++n2;
        }
    }

    RDN(int n) {
        this.assertion = new AVA[n];
    }

    public boolean equals(Object object) {
        if (object instanceof RDN) {
            return this.equals((RDN)object);
        }
        return false;
    }

    boolean equals(RDN rDN) {
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        int n = 0;
        while (n < this.assertion.length) {
            if (!this.assertion[n].equals(rDN.assertion[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.assertion.length) {
            if (this.assertion[n3].value != null) {
                n += this.assertion[n3].value.length() * n2++;
            }
            ++n3;
        }
        return n;
    }

    DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        int n = 0;
        while (n < this.assertion.length) {
            if (this.assertion[n].oid.equals(objectIdentifier)) {
                return this.assertion[n].value;
            }
            ++n;
        }
        return null;
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOrderedSetOf((byte)49, this.assertion);
    }

    public String toString() {
        String string = null;
        int n = 0;
        while (n < this.assertion.length) {
            string = string == null ? this.assertion[n].toString() : String.valueOf(string) + " + " + this.assertion[n];
            ++n;
        }
        return string;
    }
}

