/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.x509;

import com.ibm.security12.sun.security.util.BigInt;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import com.ibm.security12.sun.security.x509.AttributeNameEnumeration;
import com.ibm.security12.sun.security.x509.CertAttrSet;
import com.ibm.security12.sun.security.x509.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

public class CRLNumberExtension
extends Extension
implements CertAttrSet {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private static final int[] CRLNumber_data = new int[]{2, 5, 29, 20};
    public static final String NAME = "CRLNumber";
    public static final String NUMBER = "value";
    private BigInt crlNumber;

    private void encodeThis() throws IOException {
        if (this.crlNumber == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.crlNumber);
        this.extensionValue = derOutputStream.toByteArray();
    }

    public CRLNumberExtension(int n) throws IOException {
        this.crlNumber = new BigInt(n);
        this.extensionId = new ObjectIdentifier(CRLNumber_data);
        this.critical = false;
        this.encodeThis();
    }

    public CRLNumberExtension(BigInteger bigInteger) throws IOException {
        this.crlNumber = new BigInt(bigInteger);
        this.extensionId = new ObjectIdentifier(CRLNumber_data);
        this.critical = false;
        this.encodeThis();
    }

    public CRLNumberExtension(Boolean bl, Object object) throws IOException {
        this.extensionId = new ObjectIdentifier(CRLNumber_data);
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = Array.getByte(object, n2);
            ++n2;
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.crlNumber = derValue.getInteger();
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(NUMBER)) {
            if (!(object instanceof BigInteger)) {
                throw new IOException("Attribute must be of type BigInteger.");
            }
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
        }
        this.crlNumber = new BigInt((BigInteger)object);
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(NUMBER)) {
            if (this.crlNumber == null) {
                return null;
            }
            return this.crlNumber.toBigInteger();
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(NUMBER)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CRLNumber.");
        }
        this.crlNumber = null;
        this.encodeThis();
    }

    public String toString() {
        String string = String.valueOf(super.toString()) + "CRL Number: " + (this.crlNumber == null ? "" : this.crlNumber.toString()) + "\n";
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = new ObjectIdentifier(CRLNumber_data);
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NUMBER);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

