/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.provider;

import com.ibm.security12.java.security.GeneralSecurityException;
import com.ibm.security12.sun.security.util.PropertyExpander;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PolicyParser {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private Vector grantEntries = new Vector();
    private static final boolean debug = false;
    private StreamTokenizer st;
    private int lookahead;
    private int linenum;
    private boolean expandProp = false;
    private String keyStoreUrlString;
    private String keyStoreType;

    private String expand(String string) throws PropertyExpander.ExpandException {
        if (this.expandProp) {
            return PropertyExpander.expand(string);
        }
        return string;
    }

    public PolicyParser() {
    }

    public PolicyParser(boolean bl) {
        this();
        this.expandProp = bl;
    }

    public void read(Reader reader) throws ParsingException, IOException {
        if (!(reader instanceof BufferedReader)) {
            reader = new BufferedReader(reader);
        }
        this.st = new StreamTokenizer(reader);
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(46, 46);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(160, 255);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(47);
        this.st.quoteChar(39);
        this.st.quoteChar(34);
        this.st.lowerCaseMode(false);
        this.st.ordinaryChar(47);
        this.st.slashSlashComments(true);
        this.st.slashStarComments(true);
        this.lookahead = this.st.nextToken();
        while (this.lookahead != -1) {
            if (this.peek("grant")) {
                GrantEntry grantEntry = this.parseGrantEntry();
                if (grantEntry != null) {
                    this.add(grantEntry);
                }
            } else if (this.peek("keystore") && this.keyStoreUrlString == null) {
                this.parseKeyStoreEntry();
            }
            this.match(";");
        }
    }

    public void add(GrantEntry grantEntry) {
        this.grantEntries.addElement(grantEntry);
    }

    public void replace(GrantEntry grantEntry, GrantEntry grantEntry2) {
        this.grantEntries.setElementAt(grantEntry2, this.grantEntries.indexOf(grantEntry));
    }

    public boolean remove(GrantEntry grantEntry) {
        return this.grantEntries.removeElement(grantEntry);
    }

    public String getKeyStoreUrl() {
        try {
            if (this.keyStoreUrlString != null && this.keyStoreUrlString.length() != 0) {
                return this.expand(this.keyStoreUrlString).replace(File.separatorChar, '/');
            }
        }
        catch (PropertyExpander.ExpandException expandException) {
            return null;
        }
        return null;
    }

    public void setKeyStoreUrl(String string) {
        this.keyStoreUrlString = string;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String string) {
        this.keyStoreType = string;
    }

    public Enumeration grantElements() {
        return this.grantEntries.elements();
    }

    public void write(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        Enumeration enumeration = this.grantElements();
        printWriter.println("/* AUTOMATICALLY GENERATED ON " + new Date() + "*/");
        printWriter.println("/* DO NOT EDIT */");
        printWriter.println();
        if (this.keyStoreUrlString != null) {
            this.writeKeyStoreEntry(printWriter);
        }
        while (enumeration.hasMoreElements()) {
            GrantEntry grantEntry = (GrantEntry)enumeration.nextElement();
            grantEntry.write(printWriter);
            printWriter.println();
        }
        printWriter.flush();
    }

    private void parseKeyStoreEntry() throws ParsingException, IOException {
        this.match("keystore");
        this.keyStoreUrlString = this.match("quoted string");
        if (!this.peek(",")) {
            return;
        }
        this.match(",");
        if (this.peek("\"")) {
            this.keyStoreType = this.match("quoted string");
            return;
        }
        throw new ParsingException(this.st.lineno(), "expected keystore type");
    }

    private void writeKeyStoreEntry(PrintWriter printWriter) {
        printWriter.print("keystore \"");
        printWriter.print(this.keyStoreUrlString);
        printWriter.print('\"');
        if (this.keyStoreType != null && this.keyStoreType.length() > 0) {
            printWriter.print(", \"" + this.keyStoreType + "\"");
        }
        printWriter.println(";");
        printWriter.println();
    }

    private GrantEntry parseGrantEntry() throws ParsingException, IOException {
        GrantEntry grantEntry = new GrantEntry();
        this.match("grant");
        while (!this.peek("{")) {
            if (this.peekAndMatch("Codebase")) {
                grantEntry.codeBase = this.match("quoted string");
                this.peekAndMatch(",");
                continue;
            }
            if (this.peekAndMatch("SignedBy")) {
                grantEntry.signedBy = this.match("quoted string");
                this.peekAndMatch(",");
                continue;
            }
            throw new ParsingException(this.st.lineno(), "expected codeBase or SignedBy");
        }
        this.match("{");
        while (!this.peek("}")) {
            if (this.peek("Permission")) {
                try {
                    PermissionEntry permissionEntry = this.parsePermissionEntry();
                    grantEntry.add(permissionEntry);
                }
                catch (PropertyExpander.ExpandException expandException) {}
                this.match(";");
                continue;
            }
            throw new ParsingException(this.st.lineno(), "expected permission entry");
        }
        this.match("}");
        try {
            if (grantEntry.codeBase != null) {
                grantEntry.codeBase = this.expand(grantEntry.codeBase).replace(File.separatorChar, '/');
            }
            grantEntry.signedBy = this.expand(grantEntry.signedBy);
        }
        catch (PropertyExpander.ExpandException expandException) {
            return null;
        }
        return grantEntry;
    }

    private PermissionEntry parsePermissionEntry() throws ParsingException, IOException, PropertyExpander.ExpandException {
        PermissionEntry permissionEntry = new PermissionEntry();
        this.match("Permission");
        permissionEntry.permission = this.match("permission type");
        if (this.peek("\"")) {
            permissionEntry.name = this.expand(this.match("quoted string"));
        }
        if (!this.peek(",")) {
            return permissionEntry;
        }
        this.match(",");
        if (this.peek("\"")) {
            permissionEntry.action = this.expand(this.match("quoted string"));
            if (!this.peek(",")) {
                return permissionEntry;
            }
            this.match(",");
        }
        if (this.peekAndMatch("SignedBy")) {
            permissionEntry.signedBy = this.expand(this.match("quoted string"));
        }
        return permissionEntry;
    }

    private boolean peekAndMatch(String string) throws ParsingException, IOException {
        if (this.peek(string)) {
            this.match(string);
            return true;
        }
        return false;
    }

    private boolean peek(String string) {
        boolean bl = false;
        switch (this.lookahead) {
            case -3: {
                if (!string.equalsIgnoreCase(this.st.sval)) break;
                bl = true;
                break;
            }
            case 44: {
                if (!string.equalsIgnoreCase(",")) break;
                bl = true;
                break;
            }
            case 123: {
                if (!string.equalsIgnoreCase("{")) break;
                bl = true;
                break;
            }
            case 125: {
                if (!string.equalsIgnoreCase("}")) break;
                bl = true;
                break;
            }
            case 34: {
                if (!string.equalsIgnoreCase("\"")) break;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private String match(String string) throws ParsingException, IOException {
        String string2 = null;
        switch (this.lookahead) {
            case -2: {
                throw new ParsingException(this.st.lineno(), string, "number " + String.valueOf(this.st.nval));
            }
            case -1: {
                throw new ParsingException("expected " + string + ", read end of file");
            }
            case -3: {
                if (string.equalsIgnoreCase(this.st.sval)) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = this.st.sval.equals("java.awt.AWTPermission") || this.st.sval.equals("java.io.FilePermission") || this.st.sval.equals("java.io.SerializablePermission") || this.st.sval.equals("java.lang.RuntimePermission") || this.st.sval.equals("java.net.NetPermission") || this.st.sval.equals("java.net.SocketPermission") || this.st.sval.equals("java.security.AllPermission") || this.st.sval.equals("java.security.BasicPermission") || this.st.sval.equals("java.security.Permission") || this.st.sval.equals("java.security.SecurityPermission") || this.st.sval.equals("java.security.UnresolvedPermission") || this.st.sval.equals("java.util.PropertyPermission") ? "com.ibm.security12." + this.st.sval : this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, this.st.sval);
            }
            case 34: {
                if (string.equalsIgnoreCase("quoted string")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                if (string.equalsIgnoreCase("permission type")) {
                    string2 = this.st.sval;
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, this.st.sval);
            }
            case 44: {
                if (string.equalsIgnoreCase(",")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, ",");
            }
            case 123: {
                if (string.equalsIgnoreCase("{")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "{");
            }
            case 125: {
                if (string.equalsIgnoreCase("}")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, "}");
            }
            case 59: {
                if (string.equalsIgnoreCase(";")) {
                    this.lookahead = this.st.nextToken();
                    break;
                }
                throw new ParsingException(this.st.lineno(), string, ";");
            }
            default: {
                throw new ParsingException(this.st.lineno(), string, new String(new char[]{(char)this.lookahead}));
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        PolicyParser policyParser = new PolicyParser(true);
        policyParser.read(new FileReader(stringArray[0]));
        FileWriter fileWriter = new FileWriter(stringArray[1]);
        policyParser.write(fileWriter);
        fileWriter.close();
    }

    public static class GrantEntry {
        public String signedBy;
        public String codeBase;
        public Vector permissionEntries;

        public GrantEntry() {
            this.permissionEntries = new Vector();
        }

        public GrantEntry(String string, String string2) {
            this.codeBase = string2;
            this.signedBy = string;
            this.permissionEntries = new Vector();
        }

        public void add(PermissionEntry permissionEntry) {
            this.permissionEntries.addElement(permissionEntry);
        }

        public boolean remove(PermissionEntry permissionEntry) {
            return this.permissionEntries.removeElement(permissionEntry);
        }

        public boolean contains(PermissionEntry permissionEntry) {
            return this.permissionEntries.contains(permissionEntry);
        }

        public Enumeration permissionElements() {
            return this.permissionEntries.elements();
        }

        public void write(PrintWriter printWriter) {
            printWriter.print("grant");
            if (this.signedBy != null) {
                printWriter.print(" signedBy \"");
                printWriter.print(this.signedBy);
                printWriter.print('\"');
                if (this.codeBase != null) {
                    printWriter.print(", ");
                }
            }
            if (this.codeBase != null) {
                printWriter.print(" codeBase \"");
                printWriter.print(this.codeBase);
                printWriter.print('\"');
            }
            printWriter.println(" {");
            Enumeration enumeration = this.permissionEntries.elements();
            while (enumeration.hasMoreElements()) {
                PermissionEntry permissionEntry = (PermissionEntry)enumeration.nextElement();
                printWriter.write("  ");
                permissionEntry.write(printWriter);
            }
            printWriter.println("};");
        }
    }

    public static class PermissionEntry {
        public String permission;
        public String name;
        public String action;
        public String signedBy;

        public PermissionEntry() {
        }

        public PermissionEntry(String string, String string2, String string3) {
            this.permission = string;
            this.name = string2;
            this.action = string3;
        }

        public int hashCode() {
            int n = this.permission.hashCode();
            if (this.name != null) {
                n ^= this.name.hashCode();
            }
            if (this.action != null) {
                n ^= this.action.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PermissionEntry)) {
                return false;
            }
            PermissionEntry permissionEntry = (PermissionEntry)object;
            if (this.permission == null ? permissionEntry.permission != null : !this.permission.equals(permissionEntry.permission)) {
                return false;
            }
            if (this.name == null ? permissionEntry.name != null : !this.name.equals(permissionEntry.name)) {
                return false;
            }
            if (this.action == null ? permissionEntry.action != null : !this.action.equals(permissionEntry.action)) {
                return false;
            }
            return !(this.signedBy == null ? permissionEntry.signedBy != null : !this.signedBy.equals(permissionEntry.signedBy));
        }

        public void write(PrintWriter printWriter) {
            printWriter.print("permission ");
            printWriter.print(this.permission);
            if (this.name != null) {
                printWriter.print(" \"");
                printWriter.print(this.name);
                printWriter.print('\"');
            }
            if (this.action != null) {
                printWriter.print(", \"");
                printWriter.print(this.action);
                printWriter.print('\"');
            }
            if (this.signedBy != null) {
                printWriter.print(", signedBy \"");
                printWriter.print(this.signedBy);
                printWriter.print('\"');
            }
            printWriter.println(";");
        }
    }

    public static class ParsingException
    extends GeneralSecurityException {
        public ParsingException(String string) {
            super(string);
        }

        public ParsingException(int n, String string) {
            super("line " + n + ": " + string);
        }

        public ParsingException(int n, String string, String string2) {
            super("line " + n + ": expected '" + string + "', found '" + string2 + "'");
        }
    }
}

