/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.provider;

import com.ibm.security12.java.security.AlgorithmParameters;
import com.ibm.security12.java.security.spec.DSAParameterSpec;
import com.ibm.security12.java.security.spec.InvalidParameterSpecException;
import com.ibm.security12.sun.security.pkcs.PKCS8Key;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.x509.AlgIdDSA;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;

public final class DSAPrivateKey
extends PKCS8Key
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    private static final long serialVersionUID = -3244453684193605938L;
    private BigInteger x;
    static /* synthetic */ Class class$com$ibm$security12$java$security$spec$DSAParameterSpec;

    public DSAPrivateKey() {
    }

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.x = bigInteger;
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
            return;
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("could not DER encode x: " + iOException.getMessage());
        }
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        this.clearOldKey();
        this.decode(byArray);
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            AlgorithmParameters algorithmParameters = this.algid.getParameters();
            if (algorithmParameters == null) {
                return null;
            }
            DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameters.getParameterSpec(class$com$ibm$security12$java$security$spec$DSAParameterSpec != null ? class$com$ibm$security12$java$security$spec$DSAParameterSpec : (class$com$ibm$security12$java$security$spec$DSAParameterSpec = DSAPrivateKey.class$("com.ibm.security12.java.security.spec.DSAParameterSpec")));
            return dSAParameterSpec;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    public BigInteger getX() {
        return this.x;
    }

    private void clearOldKey() {
        int n;
        if (this.encodedKey != null) {
            n = 0;
            while (n < this.encodedKey.length) {
                this.encodedKey[n] = 0;
                ++n;
            }
        }
        if (this.key != null) {
            n = 0;
            while (n < this.key.length) {
                this.key[n] = 0;
                ++n;
            }
        }
    }

    public String toString() {
        return "Sun DSA Private Key \nparameters:" + this.algid + "\nx: " + this.x.toString(16) + "\n";
    }

    protected void parseKeyBits() throws InvalidKeyException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger().toBigInteger();
            return;
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

