/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.pkcs;

import com.ibm.security12.sun.security.pkcs.PKCS9Attribute;
import com.ibm.security12.sun.security.util.DerEncoder;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import com.ibm.security12.sun.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public class PKCS9Attributes {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private final Hashtable attributes = new Hashtable(3);
    private final Hashtable permittedAttributes;
    private final byte[] derEncoding;

    public PKCS9Attributes(ObjectIdentifier[] objectIdentifierArray, DerInputStream derInputStream) throws IOException {
        if (objectIdentifierArray != null) {
            this.permittedAttributes = new Hashtable(objectIdentifierArray.length);
            int n = 0;
            while (n < objectIdentifierArray.length) {
                this.permittedAttributes.put(objectIdentifierArray[n], objectIdentifierArray[n]);
                ++n;
            }
        } else {
            this.permittedAttributes = null;
        }
        this.derEncoding = this.decode(derInputStream);
    }

    public PKCS9Attributes(DerInputStream derInputStream) throws IOException {
        this.derEncoding = this.decode(derInputStream);
        this.permittedAttributes = null;
    }

    public PKCS9Attributes(PKCS9Attribute[] pKCS9AttributeArray) throws IllegalArgumentException, IOException {
        int n = 0;
        while (n < pKCS9AttributeArray.length) {
            ObjectIdentifier objectIdentifier = pKCS9AttributeArray[n].getOID();
            if (this.attributes.containsKey(objectIdentifier)) {
                throw new IllegalArgumentException("PKCSAttribute " + pKCS9AttributeArray[n].getOID() + " duplicated while constructing " + "PKCS9Attributes.");
            }
            this.attributes.put(objectIdentifier, pKCS9AttributeArray[n]);
            ++n;
        }
        this.derEncoding = this.generateDerEncoding();
        this.permittedAttributes = null;
    }

    private byte[] decode(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        byte[] byArray = derValue.toByteArray();
        byArray[0] = 49;
        DerInputStream derInputStream2 = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream2.getSet(3, true);
        int n = 0;
        while (n < derValueArray.length) {
            PKCS9Attribute pKCS9Attribute = new PKCS9Attribute(derValueArray[n]);
            ObjectIdentifier objectIdentifier = pKCS9Attribute.getOID();
            if (this.attributes.get(objectIdentifier) != null) {
                throw new IOException("Duplicate PKCS9 attribute: " + objectIdentifier);
            }
            if (this.permittedAttributes != null && !this.permittedAttributes.containsKey(objectIdentifier)) {
                throw new IOException("Attribute " + objectIdentifier + " not permitted in this attribute set");
            }
            this.attributes.put(objectIdentifier, pKCS9Attribute);
            ++n;
        }
        return byArray;
    }

    public void encode(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
        outputStream.write(this.derEncoding, 1, this.derEncoding.length - 1);
    }

    private byte[] generateDerEncoding() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        Object[] objectArray = null;
        derOutputStream.putOrderedSetOf((byte)49, PKCS9Attributes.castToDerEncoder(objectArray));
        return derOutputStream.toByteArray();
    }

    public byte[] getDerEncoding() throws IOException {
        return (byte[])this.derEncoding.clone();
    }

    public PKCS9Attribute getAttribute(ObjectIdentifier objectIdentifier) {
        return (PKCS9Attribute)this.attributes.get(objectIdentifier);
    }

    public PKCS9Attribute getAttribute(String string) {
        return (PKCS9Attribute)this.attributes.get(PKCS9Attribute.getOID(string));
    }

    public PKCS9Attribute[] getAttributes() {
        PKCS9Attribute[] pKCS9AttributeArray = new PKCS9Attribute[this.attributes.size()];
        int n = 0;
        int n2 = 1;
        while (n2 < PKCS9Attribute.PKCS9_OIDS.length && n < pKCS9AttributeArray.length) {
            pKCS9AttributeArray[n] = this.getAttribute(PKCS9Attribute.PKCS9_OIDS[n2]);
            if (pKCS9AttributeArray[n] != null) {
                ++n;
            }
            ++n2;
        }
        return pKCS9AttributeArray;
    }

    public Object getAttributeValue(ObjectIdentifier objectIdentifier) throws IOException {
        try {
            Object object = this.getAttribute(objectIdentifier).getValue();
            return object;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("No value found for attribute " + objectIdentifier);
        }
    }

    public Object getAttributeValue(String string) throws IOException {
        ObjectIdentifier objectIdentifier = PKCS9Attribute.getOID(string);
        if (objectIdentifier == null) {
            throw new IOException("Attribute name " + string + " not recognized or not supported.");
        }
        return this.getAttributeValue(objectIdentifier);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("PKCS9 Attributes: [\n\t");
        boolean bl = true;
        int n = 1;
        while (n < PKCS9Attribute.PKCS9_OIDS.length) {
            PKCS9Attribute pKCS9Attribute = this.getAttribute(PKCS9Attribute.PKCS9_OIDS[n]);
            if (pKCS9Attribute != null) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(";\n\t");
                }
                stringBuffer.append(pKCS9Attribute.toString());
            }
            ++n;
        }
        stringBuffer.append("\n\t] (end PKCS9 Attributes)");
        return stringBuffer.toString();
    }

    static DerEncoder[] castToDerEncoder(Object[] objectArray) {
        DerEncoder[] derEncoderArray = new DerEncoder[objectArray.length];
        int n = 0;
        while (n < derEncoderArray.length) {
            derEncoderArray[n] = (DerEncoder)objectArray[n];
            ++n;
        }
        return derEncoderArray;
    }
}

