/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.sun.security.pkcs;

import com.ibm.security12.java.util.Collection;
import com.ibm.security12.java.util.Collections;
import com.ibm.security12.java.util.Hashtable;
import com.ibm.security12.sun.security.pkcs.PKCS10Attribute;
import com.ibm.security12.sun.security.util.DerEncoder;
import com.ibm.security12.sun.security.util.DerInputStream;
import com.ibm.security12.sun.security.util.DerOutputStream;
import com.ibm.security12.sun.security.util.DerValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class PKCS10Attributes
implements DerEncoder {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private Hashtable map = new Hashtable(3);

    public PKCS10Attributes() {
    }

    public PKCS10Attributes(PKCS10Attribute[] pKCS10AttributeArray) {
        int n = 0;
        while (n < pKCS10AttributeArray.length) {
            this.map.put(pKCS10AttributeArray[n].getAttributeId().toString(), pKCS10AttributeArray[n]);
            ++n;
        }
    }

    public PKCS10Attributes(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSet(3, true);
        if (derValueArray == null) {
            throw new IOException("Illegal encoding of attributes");
        }
        int n = 0;
        while (n < derValueArray.length) {
            PKCS10Attribute pKCS10Attribute = new PKCS10Attribute(derValueArray[n]);
            this.map.put(pKCS10Attribute.getAttributeId().toString(), pKCS10Attribute);
            ++n;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.derEncode(outputStream);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        Collection collection = this.map.values();
        DerEncoder[] derEncoderArray = (PKCS10Attribute[])collection.toArray(new PKCS10Attribute[this.map.size()]);
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOrderedSetOf(DerValue.createTag((byte)-128, true, (byte)0), derEncoderArray);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void setAttribute(String string, Object object) {
        this.map.put(string, object);
    }

    public Object getAttribute(String string) {
        return this.map.get(string);
    }

    public void deleteAttribute(String string) {
        this.map.remove(string);
    }

    public Enumeration getElements() {
        return this.map.elements();
    }

    public Collection getAttributes() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PKCS10Attributes)) {
            return false;
        }
        Collection collection = ((PKCS10Attributes)object).getAttributes();
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        if (n != this.map.size()) {
            return false;
        }
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] instanceof PKCS10Attribute) {
                PKCS10Attribute pKCS10Attribute = (PKCS10Attribute)objectArray[n2];
                string = pKCS10Attribute.getAttributeId().toString();
                if (string == null) {
                    return false;
                }
                PKCS10Attribute pKCS10Attribute2 = (PKCS10Attribute)this.map.get(string);
                if (pKCS10Attribute2 == null) {
                    return false;
                }
                if (!pKCS10Attribute2.equals(pKCS10Attribute)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        String string = String.valueOf(this.map.size()) + "\n" + this.map.toString();
        return string;
    }
}

