/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.util.jar;

import com.ibm.security12.java.security.cert.Certificate;
import com.ibm.security12.java.util.jar.Attributes;
import com.ibm.security12.java.util.jar.JarEntry;
import com.ibm.security12.java.util.jar.JarVerifier;
import com.ibm.security12.java.util.jar.Manifest;
import com.ibm.security12.java.util.zip.ZipEntry;
import com.ibm.security12.java.util.zip.ZipFile;
import com.ibm.security12.sun.security.util.ManifestEntryVerifier;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class JarFile
extends ZipFile {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private Manifest man;
    private JarEntry manEntry;
    private boolean manLoaded;
    private JarVerifier jv;
    private boolean jvInitialized;
    private boolean verify;
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";

    public JarFile(String string) throws IOException {
        this(string, true);
    }

    public JarFile(String string, boolean bl) throws IOException {
        super(string);
        this.verify = bl;
    }

    public JarFile(File file) throws IOException {
        this(file.getPath(), true);
    }

    public JarFile(File file, boolean bl) throws IOException {
        this(file.getPath(), bl);
    }

    public Manifest getManifest() throws IOException {
        if (!this.manLoaded) {
            Object object;
            this.manEntry = this.getJarEntry(MANIFEST_NAME);
            if (this.manEntry == null) {
                object = this.entries();
                while (object.hasMoreElements() && this.manEntry == null) {
                    this.manEntry = (JarEntry)object.nextElement();
                    if (MANIFEST_NAME.equalsIgnoreCase(this.manEntry.getName())) continue;
                    this.manEntry = null;
                }
            }
            if (this.manEntry != null) {
                if (this.verify) {
                    object = this.getBytes(this.manEntry);
                    this.man = new Manifest(new ByteArrayInputStream((byte[])object));
                    this.jv = new JarVerifier(this.man, (byte[])object);
                } else {
                    this.man = new Manifest(super.getInputStream(this.manEntry));
                }
            }
            this.manLoaded = true;
        }
        return this.man;
    }

    public JarEntry getManifestEntry() {
        return this.manEntry;
    }

    public JarEntry getJarEntry(String string) {
        return (JarEntry)this.getEntry(string);
    }

    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry = super.getEntry(string);
        if (zipEntry != null) {
            return new JarFileEntry(zipEntry);
        }
        return null;
    }

    public Enumeration entries() {
        Enumeration enumeration = super.entries();
        return new 1(enumeration, this);
    }

    private void initializeVerifier() {
        ManifestEntryVerifier manifestEntryVerifier = null;
        Enumeration enumeration = this.entries();
        try {
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)enumeration.nextElement();
                String string = jarEntry.getName().toUpperCase();
                if (string.startsWith("META-INF/")) {
                    byte[] byArray;
                    if (jarEntry.isDirectory()) continue;
                    if (manifestEntryVerifier == null) {
                        manifestEntryVerifier = new ManifestEntryVerifier(this.man);
                    }
                    if ((byArray = this.getBytes(jarEntry)) == null || byArray.length <= 0) continue;
                    this.jv.beginEntry(jarEntry, manifestEntryVerifier);
                    this.jv.update(byArray.length, byArray, 0, byArray.length, manifestEntryVerifier);
                    this.jv.update(-1, null, 0, 0, manifestEntryVerifier);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            this.jv = null;
        }
        if (this.jv != null) {
            this.jv.doneWithMeta();
            if (JarVerifier.debug != null) {
                JarVerifier.debug.println("done with meta!");
            }
            if (this.jv.nothingToVerify()) {
                if (JarVerifier.debug != null) {
                    JarVerifier.debug.println("nothing to verify!");
                }
                this.jv = null;
            }
        }
    }

    private byte[] getBytes(ZipEntry zipEntry) throws IOException {
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        DataInputStream dataInputStream = new DataInputStream(super.getInputStream(zipEntry));
        dataInputStream.readFully(byArray, 0, byArray.length);
        dataInputStream.close();
        return byArray;
    }

    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (!this.manLoaded) {
            this.getManifest();
        }
        if (this.jv == null) {
            return super.getInputStream(zipEntry);
        }
        if (!this.jvInitialized) {
            this.initializeVerifier();
            this.jvInitialized = true;
            if (this.jv == null) {
                return super.getInputStream(zipEntry);
            }
        }
        return new JarVerifier.VerifierStream(this.man, (JarEntry)zipEntry, super.getInputStream(zipEntry), this.jv);
    }

    private static final class 1
    implements Enumeration {
        private final /* synthetic */ JarFile this$0;
        private final /* synthetic */ Enumeration val$enum;

        public boolean hasMoreElements() {
            return this.val$enum.hasMoreElements();
        }

        public Object nextElement() {
            ZipEntry zipEntry = (ZipEntry)this.val$enum.nextElement();
            return this.this$0.new JarFileEntry(zipEntry);
        }

        /* synthetic */ 1(Enumeration enumeration, JarFile jarFile) {
            this.val$enum = enumeration;
            this.this$0 = jarFile;
        }
    }

    private class JarFileEntry
    extends JarEntry {
        JarFileEntry(ZipEntry zipEntry) {
            super(zipEntry);
            JarFile.this = JarFile.this;
        }

        public Attributes getAttributes() throws IOException {
            Manifest manifest = JarFile.this.getManifest();
            if (manifest != null) {
                return manifest.getAttributes(this.getName());
            }
            return null;
        }

        public Certificate[] getCertificates() {
            Certificate[] certificateArray;
            if (this.certs == null && JarFile.this.jv != null && (certificateArray = JarFile.this.jv.getCerts(this.getName())) != null) {
                this.certs = (Certificate[])certificateArray.clone();
            }
            return this.certs;
        }
    }
}

