/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.security.AccessControlContext;
import com.ibm.security12.java.security.PrivilegedAction;
import com.ibm.security12.java.security.PrivilegedActionException;
import com.ibm.security12.java.security.PrivilegedExceptionAction;
import com.ibm.security12.java.security.ProtectionDomain;
import com.ibm.security12.java.security.ProtectionDomainStore;
import com.ibm.security12.java.security.ThreadProtectionContextSecurityManager;
import com.ibm.security12.java.security.ThreadProtectionNative;
import java.util.Vector;

final class ThreadProtectionContext {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    static ThreadProtectionContextSecurityManager captiveSecurityManager = new ThreadProtectionContextSecurityManager();

    static AccessControlContext getStackAccessControlContext() {
        AccessControlContext accessControlContext = null;
        ProtectionDomain[] protectionDomainArray = null;
        int n = 0;
        try {
            accessControlContext = ThreadProtectionNative.getStackAccessControlContext();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (accessControlContext == null) {
            try {
                n = ThreadProtectionNative.getPrivilegedMethodOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            protectionDomainArray = ThreadProtectionContext.getProtectionDomain(n);
            if (protectionDomainArray != null) {
                accessControlContext = new AccessControlContext(protectionDomainArray);
            }
        }
        if (accessControlContext == null) {
            accessControlContext = new AccessControlContext(null, true);
        }
        return accessControlContext;
    }

    static AccessControlContext getInheritedAccessControlContext() {
        AccessControlContext accessControlContext = null;
        try {
            accessControlContext = ThreadProtectionNative.getInheritedAccessControlContext(Thread.currentThread());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        if (accessControlContext == null) {
            accessControlContext = new AccessControlContext(null, true);
        }
        return accessControlContext;
    }

    private ThreadProtectionContext() {
    }

    static ProtectionDomain[] getProtectionDomain(int n) {
        ProtectionDomain[] protectionDomainArray;
        Vector<ProtectionDomain> vector = new Vector<ProtectionDomain>(10);
        Class[] classArray = captiveSecurityManager.getClassContext();
        int n2 = classArray.length - n;
        int n3 = 0;
        while (n3 < n2) {
            ProtectionDomain protectionDomain = ProtectionDomainStore.getPD(classArray[n3]);
            if (protectionDomain != null) {
                vector.addElement(protectionDomain);
            }
            ++n3;
        }
        if (!vector.isEmpty()) {
            protectionDomainArray = new ProtectionDomain[vector.size()];
            int n4 = 0;
            while (n4 < vector.size()) {
                protectionDomainArray[n4] = (ProtectionDomain)vector.elementAt(n4);
                ++n4;
            }
        } else {
            protectionDomainArray = new ProtectionDomain[]{};
        }
        return protectionDomainArray;
    }

    static Object doPrivileged(PrivilegedAction privilegedAction) {
        return ThreadProtectionNative.doPrivileged(privilegedAction, captiveSecurityManager.getPrivilegedOffset());
    }

    static Object doPrivileged(PrivilegedAction privilegedAction, AccessControlContext accessControlContext) {
        return ThreadProtectionNative.doPrivileged(privilegedAction, accessControlContext);
    }

    static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return ThreadProtectionNative.doPrivileged(privilegedExceptionAction, captiveSecurityManager.getPrivilegedOffset());
    }

    public static Object doPrivileged(PrivilegedExceptionAction privilegedExceptionAction, AccessControlContext accessControlContext) throws PrivilegedActionException {
        return ThreadProtectionNative.doPrivileged(privilegedExceptionAction, accessControlContext);
    }
}

