/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security12.java.security;

import com.ibm.security12.java.lang.ClassLoader12;
import com.ibm.security12.java.lang.SecurityManager12;
import com.ibm.security12.java.security.CodeSource;
import com.ibm.security12.java.security.PermissionCollection;
import com.ibm.security12.java.security.Policy;
import com.ibm.security12.java.security.ProtectionDomain;
import com.ibm.security12.sun.security.util.Debug;
import java.util.Hashtable;

public class SecureClassLoader
extends ClassLoader12 {
    static final String copyr = "Licensed Materials - Property of IBM\nIBM Developer Kit, Java(TM) Tech Edition\n(c) Copyright IBM Corp. 1996, 1999. All rights reserved.\n\nUS Government Users Restricted Rights - Use,\nduplication or disclosure restricted by GSA\nADP Schedule Contract with IBM Corp.\n";
    private Hashtable pdcache = new Hashtable(11);
    private static final Debug debug = Debug.getInstance("scl");

    protected SecureClassLoader(ClassLoader12 classLoader12) {
        super(classLoader12);
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkCreateClassLoader();
        }
    }

    protected SecureClassLoader() {
        SecurityManager12 securityManager12 = (SecurityManager12)System.getSecurityManager();
        if (securityManager12 != null) {
            securityManager12.checkCreateClassLoader();
        }
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, CodeSource codeSource) {
        if (codeSource == null) {
            return this.defineClass(string, byArray, n, n2);
        }
        return this.defineClass(string, byArray, n, n2, this.getProtectionDomain(codeSource));
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Policy policy = Policy.getPolicyNoCheck();
        if (policy == null) {
            return null;
        }
        PermissionCollection permissionCollection = policy.getPermissions(codeSource);
        return permissionCollection;
    }

    private ProtectionDomain getProtectionDomain(CodeSource codeSource) {
        if (codeSource == null) {
            return null;
        }
        ProtectionDomain protectionDomain = (ProtectionDomain)this.pdcache.get(codeSource);
        if (protectionDomain == null) {
            Hashtable hashtable = this.pdcache;
            synchronized (hashtable) {
                protectionDomain = (ProtectionDomain)this.pdcache.get(codeSource);
                if (protectionDomain == null) {
                    PermissionCollection permissionCollection = this.getPermissions(codeSource);
                    if (debug != null) {
                        debug.println(" getPermissions " + codeSource);
                        debug.println("  " + permissionCollection);
                        debug.println("");
                    }
                    if ((protectionDomain = new ProtectionDomain(codeSource, permissionCollection)) != null) {
                        this.pdcache.put(codeSource, protectionDomain);
                    }
                }
            }
        }
        return protectionDomain;
    }
}

