/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    FocusListener focusDelegator;

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setRequestFocusEnabled(!this.comboBox.isEditable() && this.comboBox.isEnabled());
            if (this.keyListener != null) {
                this.arrowButton.addKeyListener(this.keyListener);
            }
            if (this.popupKeyListener != null) {
                this.arrowButton.addKeyListener(this.popupKeyListener);
            }
            if (this.focusListener != null) {
                this.arrowButton.addFocusListener(this.focusListener);
            }
            if (this.popupMouseListener != null) {
                this.arrowButton.addMouseListener(this.popupMouseListener);
            }
            if (this.popupMouseMotionListener != null) {
                this.arrowButton.addMouseMotionListener(this.popupMouseMotionListener);
            }
        }
    }

    public void configureEditor() {
        super.configureEditor();
        if (this.popupKeyListener != null) {
            this.editor.removeKeyListener(this.popupKeyListener);
        }
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
    }

    protected JButton createArrowButton() {
        MetalComboBoxButton metalComboBoxButton = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        metalComboBoxButton.setMargin(new Insets(0, 1, 1, 3));
        return metalComboBoxButton;
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    FocusListener createFocusDelegator() {
        return new FocusDelegator();
    }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    protected ComboPopup createPopup() {
        return new MetalComboPopup(this.comboBox);
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalComboBoxUI();
    }

    protected void editablePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)this.arrowButton;
            metalComboBoxButton.setIconOnly(this.comboBox.isEditable());
            metalComboBoxButton.setRequestFocusEnabled(!this.comboBox.isEditable() && this.comboBox.isEnabled());
            this.comboBox.repaint();
        }
    }

    void enabledPropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.arrowButton instanceof MetalComboBoxButton) {
            this.arrowButton.setRequestFocusEnabled(!this.comboBox.isEditable() && this.comboBox.isEnabled());
            this.comboBox.repaint();
        }
    }

    JButton getArrowButton() {
        return this.arrowButton;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null && this.arrowButton instanceof MetalComboBoxButton) {
            MetalComboBoxButton metalComboBoxButton = (MetalComboBoxButton)this.arrowButton;
            Insets insets = metalComboBoxButton.getInsets();
            Insets insets2 = this.comboBox.getInsets();
            dimension = this.getDisplaySize();
            dimension.width += insets2.left + insets2.right;
            dimension.width += insets.left + insets.right;
            dimension.width += insets.right + metalComboBoxButton.getComboIcon().getIconWidth();
            dimension.height += insets2.top + insets2.bottom;
            dimension.height += insets.top + insets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            dimension = super.getMinimumSize(jComponent);
            Insets insets = this.arrowButton.getMargin();
            Insets insets3 = this.comboBox.getInsets();
            if (this.editor instanceof JComponent) {
                Insets insets4 = ((JComponent)this.editor).getInsets();
                dimension.height += insets4.top + insets4.bottom;
            }
            dimension.height += insets.top + insets.bottom;
            dimension.height += insets3.top + insets3.bottom;
        } else {
            dimension = super.getMinimumSize(jComponent);
        }
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MetalComboBoxUI.this.isPopupVisible()) {
                    MetalComboBoxUI.this.selectNextPossibleValue();
                } else {
                    MetalComboBoxUI.this.setPopupVisible(MetalComboBoxUI.this.metalGetComboBox(), true);
                }
            }

            public boolean isEnabled() {
                return MetalComboBoxUI.this.metalGetComboBox().isEnabled();
            }
        };
        this.metalGetComboBox().registerKeyboardAction(abstractAction, KeyStroke.getKeyStroke(40, 0), 1);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalComboBoxUI.this.togglePopup();
            }

            public boolean isEnabled() {
                return MetalComboBoxUI.this.metalGetComboBox().isEnabled();
            }
        };
        this.metalGetComboBox().registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(40, 8), 1);
        this.metalGetComboBox().registerKeyboardAction(abstractAction2, KeyStroke.getKeyStroke(38, 8), 1);
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MetalComboBoxUI.this.selectPreviousPossibleValue();
            }

            public boolean isEnabled() {
                return MetalComboBoxUI.this.metalGetComboBox().isEnabled() && MetalComboBoxUI.this.isPopupVisible();
            }
        };
        this.metalGetComboBox().registerKeyboardAction(abstractAction3, KeyStroke.getKeyStroke(38, 0), 1);
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.keyListener = this.createKeyListener();
        this.focusListener = this.createFocusListener();
        this.popupKeyListener = this.popup.getKeyListener();
        this.popupMouseListener = this.popup.getMouseListener();
        this.popupMouseMotionListener = this.popup.getMouseMotionListener();
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
        if ((this.focusDelegator = this.createFocusDelegator()) != null) {
            this.comboBox.addFocusListener(this.focusDelegator);
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
    }

    public boolean isFocusTraversable(JComboBox jComboBox) {
        return false;
    }

    boolean isPopupVisible() {
        return super.isPopupVisible(this.comboBox);
    }

    public void layoutComboBox(Container container, MetalComboBoxLayoutManager metalComboBoxLayoutManager) {
        if (this.comboBox.isEditable()) {
            metalComboBoxLayoutManager.superLayout(container);
        } else if (this.arrowButton != null) {
            Insets insets = this.comboBox.getInsets();
            int n = this.comboBox.getWidth();
            int n2 = this.comboBox.getHeight();
            this.arrowButton.setBounds(insets.left, insets.top, n - (insets.left + insets.right), n2 - (insets.top + insets.bottom));
        }
    }

    JButton metalGetArrowButton() {
        return this.arrowButton;
    }

    JComboBox metalGetComboBox() {
        return this.comboBox;
    }

    Component metalGetEditor() {
        return this.editor;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void removeListeners() {
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    void togglePopup() {
        this.toggleOpenClose();
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            super.unconfigureArrowButton();
            if (this.keyListener != null) {
                this.arrowButton.removeKeyListener(this.keyListener);
            }
            if (this.popupKeyListener != null) {
                this.arrowButton.removeKeyListener(this.popupKeyListener);
            }
            if (this.focusListener != null) {
                this.arrowButton.removeFocusListener(this.focusListener);
            }
        }
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 8));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 8));
    }

    protected void uninstallListeners() {
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
        if (this.focusDelegator != null) {
            this.comboBox.removeFocusListener(this.focusDelegator);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    class FocusDelegator
    extends FocusAdapter {
        FocusDelegator() {
        }

        public void focusGained(FocusEvent focusEvent) {
            if (MetalComboBoxUI.this.metalGetComboBox().isEditable()) {
                MetalComboBoxUI.this.metalGetEditor().requestFocus();
            } else {
                MetalComboBoxUI.this.metalGetArrowButton().requestFocus();
            }
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            super.propertyChange(propertyChangeEvent);
            MetalComboBoxUI.this.metalGetComboBox().setRequestFocusEnabled(true);
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("editable")) {
                MetalComboBoxUI.this.editablePropertyChanged(propertyChangeEvent);
            } else if (string.equals("enabled")) {
                MetalComboBoxUI.this.enabledPropertyChanged(propertyChangeEvent);
            }
        }
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public void layoutContainer(Container container) {
            MetalComboBoxUI.this.layoutComboBox(container, this);
        }

        public void superLayout(Container container) {
            super.layoutContainer(container);
        }
    }

    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox jComboBox) {
            super(jComboBox);
        }

        public void delegateFocus(MouseEvent mouseEvent) {
            if (MetalComboBoxUI.this.metalGetComboBox().isEditable()) {
                MetalComboBoxUI.this.metalGetEditor().requestFocus();
            }
        }
    }
}

