#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/examples/naming/RCS/server.py,v $
# Version:      @(#)$RCSfile: server.py,v $ $Revision: 1.2 $
#
#############################################################################
""" An example of a server using the Naming Service. """


# Standard/built-in modules.
import whrandom, sys

# Fnorb modules.
from Fnorb.orb import BOA, CORBA

# Naming Service modules.
from Fnorb.cos.naming import CosNaming

# Stubs and skeletons generated by 'fnidl'.
import Thermometer, Thermometer_skel


class ThermometerImplFactory:
    """ Factory for Thermometer implementations. """

    # The 'pathname' of the context that will hold the thermometer references.
    PATH = [CosNaming.NameComponent('dev', ''), 
	    CosNaming.NameComponent('thermometers', '')]

    def __init__(self):
	""" Constructor. """

	# Start from the initial context.
	ctx = CORBA.ORB_init().resolve_initial_references("NameService")

	# Create the naming contexts for the graph...
	#
	#            initial context
	#	            |
        #                  dev
        #                   |
        #              thermometers
	#
	self.__create_contexts(ctx, ThermometerImplFactory.PATH)

	return

    def create_thermometer(self, room):
	""" Create a thermomemeter implementation. """

	# Create a thermometer implementation.
	impl = ThermometerImpl()

	# Initialise the BOA.
	boa = BOA.BOA_init()

	# Create an object reference for the thermometer using the room as
	# the object key.
	ref = boa.create(room, ThermometerImpl._FNORB_ID)

	# Get a reference to the initial context in the Naming Service.
	ctx = CORBA.ORB_init().resolve_initial_references("NameService")

	# Create a Naming Service 'name' for the thermometer.
	name = ThermometerImplFactory.PATH + [CosNaming.NameComponent(room,'')]

	# Bind the name to the thermometer's object reference.
	ctx.rebind(name, ref)

	# Activate the implementation (ie. connect the generated object
	# reference to the implementation).  Note that the implementation will
	# not receive any operation requests until we start the event loop.
	boa.obj_is_ready(ref, impl)

	return

    #########################################################################
    # Private interface.
    #########################################################################

    def __create_contexts(self, ctx, name):
	""" Create contexts for all components of the specified name. """

	try:
	    for component in name:
		ctx = ctx.bind_new_context([component])

	except CosNaming.NamingContext.AlreadyBound:
	    pass

	return


class ThermometerImpl(Thermometer_skel.ThermometerIF_skel):
    """ Implementation of the 'Thermometer' interface. """

    # readonly attribute temperature_t temperature;
    def _get_temperature(self):
	return whrandom.choice(range(-10, 30)) # ;^)

#############################################################################

def main(argv):
    """ Do it! """

    print 'Initialising the ORB...'

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    print 'Initialising the BOA...'

    # Initialise the BOA.
    boa = BOA.BOA_init(argv, BOA.BOA_ID)

    print 'Creating implementations...'

    factory = ThermometerImplFactory()
    for room in ["101", "102", "103", "104", "105"]:
	print "Creating thermometer in room", room
	factory.create_thermometer(room)

    print 'Server created and accepting requests...'

    # Start the event loop.
    boa._fnorb_mainloop()

    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
