
#include <stdio.h>
#include <stddef.h>

#include "itrccnst.h"
#include "itrcstrt.h"

FILE *fout;

unsigned long InstrumentTraceStartup(unsigned long vmID) {
	return 0;
}

unsigned long InstrumentTraceShutdown() {
	return 0;
}

unsigned long InstrumentTraceBegin(unsigned long vmID, unsigned long flags) {
	if(!(fout = fopen("output.trc", "w"))) {
		return 1;
	}
	return 0;
}

unsigned long InstrumentTraceEnd() {
	fclose(fout);
	return 0;
}

unsigned long InstrumentTraceEvent(struct InsEventInfo *event) {
	unsigned long index;
	static int reportingFields = 0;
	char *threadName, *groupName;
	unsigned long flags, threadNameLength, groupNameLength, priority;

	switch(event->header.event) {
		case InsTrcEventMethodEnter:
			fprintf(fout, "\ne %8.8p ", event->body.method.receiver);
			goto contMethod;
			break;
		case InsTrcEventMethodLeave:
			fprintf(fout, "\nl %8.8p ", event->body.method.receiver);
contMethod:
			if(event->body.method.methodEventFlags & InstrumentMethodEventStatic) {
				fputc((int)'S', fout);
			} else {
				fputc((int)'-', fout);
			}
			if(event->body.method.methodEventFlags & InstrumentMethodEventNative) {
				fputc((int)'N', fout);
			} else {
				fputc((int)'-', fout);
			}
			if(event->body.method.methodEventFlags & InstrumentMethodEventSync) {
				fputc((int)'S', fout);
			} else {
				fputc((int)'-', fout);
			}
			fputc((int)' ', fout);
			if(event->body.method.methodEventFlags & InstrumentMethodEventClassDB) {
				for(index=0;index<event->body.method.classNameSize;index++)
					fputc(((short *)event->body.method.className)[index], fout);
			} else {
				for(index=0;index<event->body.method.classNameSize;index++)
					fputc((int)(event->body.method.className[index]), fout);
			}
			fputc((int)' ', fout);
			if(event->body.method.methodEventFlags & InstrumentMethodEventMethodDB) {
				for(index=0;index<event->body.method.methodNameSize;index++)
					fputc(((short *)event->body.method.methodName)[index], fout);
			} else {
				for(index=0;index<event->body.method.methodNameSize;index++)
					fputc((int)(event->body.method.methodName[index]), fout);
			}

			fprintf(fout, " %ld Thread[", event->body.method.stackDepth);

			if(InstrumentSupportCurrentThreadDetails(event->header.vmID, &flags, &threadName, &threadNameLength, &priority, &groupName, &groupNameLength) == 0) {
				if(flags & InstrumentThreadNameDB) {
					for(index=0;index<threadNameLength;index++)
						fputc(((short *)threadName)[index], fout);
				} else {
					for(index=0;index<threadNameLength;index++)
						fputc((int)(threadName[index]), fout);
				}
				fprintf(fout, ",%ld,", priority);
				if(flags & InstrumentThreadGroupNameDB) {
					for(index=0;index<groupNameLength;index++)
						fputc(((short *)groupName)[index], fout);
				} else {
					for(index=0;index<groupNameLength;index++)
						fputc((int)(groupName[index]), fout);
				}
			}
			fputc((int)']', fout);

			break;
		case InsTrcEventOIDRename:
			fprintf(fout, "\nr %8.8p %8.8p", event->body.oidRename.source, event->body.oidRename.destination);
			break;
		case InsTrcEventOIDRangeRename:
			fprintf(fout, "\nrr %8.8p %8.8p %8.8p", event->body.oidRangeRename.sourceStart, event->body.oidRangeRename.sourceEnd, event->body.oidRangeRename.destination);
			break;
		case InsTrcEventOIDDelete:
			fprintf(fout, "\ng %8.8p", event->body.oidDelete.oid);
			break;
		case InsTrcEventOIDRangeDelete:
			fprintf(fout, "\nrg %8.8p %8.8p", event->body.oidRangeDelete.start, event->body.oidRangeDelete.end);
			break;
		case InsTrcEventScavengeStart:
			fprintf(fout, "\nscvs");
			break;
		case InsTrcEventScavengeEnd:
			fprintf(fout, "\nscve");
			break;
		case InsTrcEventGGCStart:
			fprintf(fout, "\nggcs");
			break;
		case InsTrcEventGGCEnd:
			fprintf(fout, "\nggce");
			break;
		case InsTrcEventAllocate:
			fprintf(fout, "\na %8.8p %8.8u ", event->body.allocate.oid, event->body.allocate.sizeInLongs);
			if(event->body.allocate.arrayFlag) {
				if(event->body.allocate.allocBody.array.classNameSize == 0) {
					if(event->body.allocate.allocBody.array.arity == 0) {
						fprintf(fout, "<array: object>");
					} else {
						fprintf(fout, "<array: array>");
					}
				} else {
					fprintf(fout, "<array: base type> ");
					for(index=0;index<event->body.allocate.allocBody.array.classNameSize;index++)
						fputc((int)(event->body.allocate.allocBody.array.className[index]), fout);
				}
			} else {
				if(event->body.allocate.allocBody.object.allocEventFlags & InstrumentAllocEventClassDB) {
					for(index=0;index<event->body.allocate.allocBody.object.classNameSize;index++)
						fputc(((short *)event->body.allocate.allocBody.object.className)[index], fout);
				} else {
					for(index=0;index<event->body.allocate.allocBody.object.classNameSize;index++)
						fputc((int)(event->body.allocate.allocBody.object.className[index]), fout);
				}
			}
			break;
		case InsTrcEventStartFieldReport:
			reportingFields = 1;
			switch(event->body.startFieldReport.type) {
				case InstrumentFREventTypeJava:
					fprintf(fout, "\nn %8.8p ", event->body.startFieldReport.oid);
					goto fieldReportClassName;
				case InstrumentFREventTypeJavaClass:
					fprintf(fout, "\nnc %8.8p ", event->body.startFieldReport.oid);
fieldReportClassName:
					if(event->body.startFieldReport.reportEventFlags & InstrumentReportEventClassDB) {
						for(index=0;index<event->body.startFieldReport.classNameSize;index++)
							fputc(((short *)event->body.startFieldReport.className)[index], fout);
					} else {
						for(index=0;index<event->body.startFieldReport.classNameSize;index++)
							fputc((int)(event->body.startFieldReport.className[index]), fout);
					}
					break;
				case InstrumentFREventTypeJavaArray:
					fprintf(fout, "\nn %8.8p <array>", event->body.startFieldReport.oid);
					break;
				default:
					break;
			}
			break;
		case InsTrcEventFieldReport:
			if(reportingFields)
				fprintf(fout, " %8.8p", event->body.fieldReport.oid);
			break;
		case InsTrcEventEndFieldReport:
			reportingFields = 0;
			break;
		case InsTrcEventUserEvent:
			fprintf(fout, "\nu ");
			if(event->body.user.msgEventFlags & InstrumentUserEventDB) {
				for(index=0;index<event->body.user.msgSize;index++)
					fputc(((short *)event->body.user.msg)[index], fout);
			} else {
				for(index=0;index<event->body.user.msgSize;index++)
					fputc((int)(event->body.user.msg[index]), fout);
			}
			break;
		default:
			fprintf(fout, "\n<unknown event %d>", event->header.event);
			break;
	}
	return 0;
}

